/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public final class EvaluatedParams {
    public final CompletionStage stage;
    private final CompletableFuture<?>[] results;

    public static EvaluatedParams evaluate(EvalContext context) {
        List<Expression> params = context.getParams();
        if (params.size() == 1) {
            return new EvaluatedParams(context.evaluate(params.get(0)));
        }
        CompletableFuture[] results = new CompletableFuture[params.size()];
        int i = 0;
        Iterator<Expression> it = params.iterator();
        while (it.hasNext()) {
            results[i++] = context.evaluate(it.next()).toCompletableFuture();
        }
        return new EvaluatedParams(CompletableFuture.allOf(results), results);
    }

    EvaluatedParams(CompletionStage stage) {
        this.stage = stage;
        this.results = new CompletableFuture[]{stage.toCompletableFuture()};
    }

    EvaluatedParams(CompletionStage stage, CompletableFuture[] results) {
        this.stage = stage;
        this.results = results;
    }

    public Object getResult(int index) throws InterruptedException, ExecutionException {
        return this.results[index].get();
    }

    public boolean parameterTypesMatch(boolean varargs, Class<?>[] types) throws InterruptedException, ExecutionException {
        if (types.length != this.results.length) {
            if (varargs) {
                int diff = types.length - this.results.length;
                if (diff == 1) {
                    return true;
                }
                if (diff > 1) {
                    return false;
                }
                Class<?> varargsType = types[types.length - 1];
                types[types.length - 1] = varargsType.getComponentType();
            } else {
                return false;
            }
        }
        int i = 0;
        Class<?> paramType = EvaluatedParams.boxType(types[i]);
        while (i < this.results.length) {
            Class<?> resultClass = EvaluatedParams.boxType(this.getResult(i).getClass());
            if (!paramType.isAssignableFrom(resultClass)) {
                return false;
            }
            if (types.length <= ++i) continue;
            paramType = types[i];
        }
        return true;
    }

    public Object getVarargsResults(int numberOfParameters, Class<?> componentType) throws InterruptedException, ExecutionException {
        int skip = numberOfParameters - 1;
        if (skip < 0) {
            return Array.newInstance(componentType, 0);
        }
        int idx = 0;
        Object array = Array.newInstance(componentType, this.results.length - skip);
        for (int i = skip; i < this.results.length; ++i) {
            Object result = this.getResult(i);
            Array.set(array, idx++, result);
        }
        return array;
    }

    private static Class<?> boxType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Void.TYPE)) {
            return Void.class;
        }
        throw new IllegalArgumentException();
    }
}

