/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Evaluator;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.SectionBlock;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

class ResolutionContextImpl
implements ResolutionContext {
    private final ResolutionContextImpl parent;
    private final Object data;
    private final List<NamespaceResolver> namespaceResolvers;
    private final Evaluator evaluator;
    private final Map<String, SectionBlock> extendingBlocks;

    ResolutionContextImpl(ResolutionContextImpl parent, Object data, List<NamespaceResolver> namespaceResolvers, Evaluator evaluator, Map<String, SectionBlock> extendingBlocks) {
        this.parent = parent;
        this.data = data;
        this.namespaceResolvers = namespaceResolvers;
        this.evaluator = evaluator;
        this.extendingBlocks = extendingBlocks;
    }

    @Override
    public CompletionStage<Object> evaluate(String value) {
        return this.evaluate(ExpressionImpl.from(value));
    }

    @Override
    public CompletionStage<Object> evaluate(Expression expression) {
        return this.evaluator.evaluate(expression, this);
    }

    @Override
    public ResolutionContext createChild(Object data, List<NamespaceResolver> namespaceResolvers) {
        return new ResolutionContextImpl(this, data, namespaceResolvers, this.evaluator, null);
    }

    @Override
    public ResolutionContext createChild(Map<String, SectionBlock> extendingBlocks) {
        return new ResolutionContextImpl(this, this.data, this.namespaceResolvers, this.evaluator, extendingBlocks);
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public List<NamespaceResolver> getNamespaceResolvers() {
        return this.namespaceResolvers;
    }

    @Override
    public ResolutionContextImpl getParent() {
        return this.parent;
    }

    @Override
    public SectionBlock getExtendingBlock(String name) {
        if (this.extendingBlocks != null) {
            SectionBlock block = this.extendingBlocks.get(name);
            if (block != null) {
                return block;
            }
            if (this.parent != null) {
                return this.parent.getExtendingBlock(name);
            }
        }
        return null;
    }
}

