/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class WithSectionHelper
implements SectionHelper {
    private static final String OBJECT = "object";
    private static final String WITH = "with";
    private final Expression object;
    private final SectionBlock main;

    WithSectionHelper(SectionHelperFactory.SectionInitContext context) {
        this.object = context.getExpression(OBJECT);
        this.main = context.getBlocks().get(0);
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        return context.resolutionContext().evaluate(this.object).thenCompose(with -> context.execute(this.main, context.resolutionContext().createChild(with, null)));
    }

    public static class Factory
    implements SectionHelperFactory<WithSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(WithSectionHelper.WITH);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(WithSectionHelper.OBJECT).build();
        }

        @Override
        public WithSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new WithSectionHelper(context);
        }

        @Override
        public Map<String, String> initializeBlock(Map<String, String> outerNameTypeInfos, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                String object = block.getParameters().get(WithSectionHelper.OBJECT);
                if (object == null) {
                    throw new IllegalStateException("Object param not present");
                }
                block.addExpression(WithSectionHelper.OBJECT, object);
                return outerNameTypeInfos;
            }
            return Collections.emptyMap();
        }
    }
}

