/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.compatibility.adaptor52x;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.infinispan.compatibility.adaptor52x.Adaptor52xStoreConfiguration;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStore;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.StreamingMarshallerAdapter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.InternalMetadataImpl;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.util.Util;

public class Adaptor52xStore
implements AdvancedLoadWriteStore {
    private InitializationContext ctx;
    private Adaptor52xStoreConfiguration configuration;
    private CacheLoader loader;
    private InternalEntryFactory entryFactory;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (Adaptor52xStoreConfiguration)ctx.getConfiguration();
        this.loader = this.configuration.getLoader();
        CacheLoaderConfig cacheLoaderConfig = this.instantiateCacheLoaderConfig(this.loader.getClass());
        XmlConfigHelper.setValues(cacheLoaderConfig, this.configuration.properties(), false, true);
        try {
            this.loader.init(cacheLoaderConfig, ctx.getCache(), (StreamingMarshaller)new StreamingMarshallerAdapter(ctx.getMarshaller()));
        }
        catch (CacheLoaderException e) {
            throw this.newCacheLoaderException(e);
        }
    }

    public void start() {
        try {
            this.loader.start();
        }
        catch (CacheLoaderException e) {
            throw this.newCacheLoaderException(e);
        }
        this.entryFactory = (InternalEntryFactory)this.ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
    }

    public void stop() {
        try {
            this.loader.stop();
        }
        catch (CacheLoaderException e) {
            throw this.newCacheLoaderException(e);
        }
    }

    private CacheLoaderConfig instantiateCacheLoaderConfig(Class clazz) {
        Class<? extends CacheLoaderConfig> cacheLoaderConfigType;
        CacheLoaderMetadata metadata = clazz.getAnnotation(CacheLoaderMetadata.class);
        if (metadata == null) {
            CacheLoader cl = (CacheLoader)Util.getInstance(clazz);
            cacheLoaderConfigType = cl.getConfigurationClass();
        } else {
            cacheLoaderConfigType = metadata.configurationClass();
        }
        return Util.getInstance(cacheLoaderConfigType);
    }

    public void process(AdvancedCacheLoader.KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        try {
            Set<Object> keys = this.loader.loadAllKeys(null);
            int batchSize = 1000;
            ExecutorCompletionService ecs = new ExecutorCompletionService(executor);
            int tasks = 0;
            TaskContextImpl taskContext = new TaskContextImpl();
            HashSet<Object> entries = new HashSet<Object>(batchSize);
            for (Object key : keys) {
                if (keyFilter == null || keyFilter.shouldLoadKey(key)) {
                    entries.add(key);
                }
                if (entries.size() != batchSize) continue;
                HashSet<Object> batch = entries;
                entries = new HashSet(batchSize);
                this.submitProcessTask(cacheLoaderTask, ecs, (AdvancedCacheLoader.TaskContext)taskContext, batch, fetchValue, fetchMetadata);
                ++tasks;
            }
            if (!entries.isEmpty()) {
                this.submitProcessTask(cacheLoaderTask, ecs, (AdvancedCacheLoader.TaskContext)taskContext, entries, fetchValue, fetchMetadata);
                ++tasks;
            }
            PersistenceUtil.waitForAllTasksToComplete(ecs, (int)tasks);
        }
        catch (CacheLoaderException e) {
            throw this.newCacheLoaderException(e);
        }
    }

    private void submitProcessTask(final AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, ExecutorCompletionService ecs, final AdvancedCacheLoader.TaskContext taskContext, final Set<Object> batch, final boolean loadEntry, final boolean loadMetadata) {
        ecs.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Object key : batch) {
                    if (taskContext.isStopped()) break;
                    Object marshalledEntry = !loadEntry && !loadMetadata ? new MarshalledEntryImpl(key, (Object)null, null, Adaptor52xStore.this.ctx.getMarshaller()) : Adaptor52xStore.this.load(key);
                    if (marshalledEntry == null) continue;
                    cacheLoaderTask.processEntry(marshalledEntry, taskContext);
                }
                return null;
            }
        });
    }

    public int size() {
        return PersistenceUtil.count((AdvancedCacheLoader)this, null);
    }

    public void clear() {
        if (this.loader instanceof CacheStore) {
            try {
                ((CacheStore)this.loader).clear();
            }
            catch (CacheLoaderException e) {
                throw this.newCacheLoaderException(e);
            }
        }
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener listener) {
        if (this.loader instanceof CacheStore) {
            try {
                ((CacheStore)this.loader).purgeExpired();
            }
            catch (CacheLoaderException e) {
                throw this.newCacheLoaderException(e);
            }
        }
    }

    public MarshalledEntry load(Object key) {
        try {
            InternalCacheEntry load = this.loader.load(key);
            if (load == null) {
                return null;
            }
            return new MarshalledEntryImpl(key, load.getValue(), (InternalMetadata)new InternalMetadataImpl(load), this.ctx.getMarshaller());
        }
        catch (CacheLoaderException e) {
            throw this.newCacheLoaderException(e);
        }
    }

    public boolean contains(Object key) {
        return this.load(key) != null;
    }

    public void write(MarshalledEntry entry) {
        if (this.loader instanceof CacheStore) {
            try {
                ((CacheStore)this.loader).store(this.entryFactory.create(entry.getKey(), entry.getValue(), (Metadata)entry.getMetadata()));
            }
            catch (CacheLoaderException e) {
                throw this.newCacheLoaderException(e);
            }
        }
    }

    public boolean delete(Object key) {
        if (this.loader instanceof CacheStore) {
            try {
                return ((CacheStore)this.loader).remove(key);
            }
            catch (CacheLoaderException e) {
                throw this.newCacheLoaderException(e);
            }
        }
        return false;
    }

    private org.infinispan.persistence.CacheLoaderException newCacheLoaderException(CacheLoaderException e) {
        return new org.infinispan.persistence.CacheLoaderException((Throwable)e);
    }

    public CacheLoader getLoader() {
        return this.loader;
    }
}

