/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AbstractDelegatingStore;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ChainingCacheStore
implements CacheStore {
    private static final Log log = LogFactory.getLog(ChainingCacheStore.class);
    private final ReadWriteLock loadersAndStoresMutex = new ReentrantReadWriteLock();
    @GuardedBy(value="loadersAndStoresMutex")
    private final Map<CacheLoader, CacheLoaderConfiguration> loaders = new LinkedHashMap<CacheLoader, CacheLoaderConfiguration>();
    @GuardedBy(value="loadersAndStoresMutex")
    private final Map<CacheStore, CacheStoreConfiguration> stores = new LinkedHashMap<CacheStore, CacheStoreConfiguration>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(InternalCacheEntry ed) throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                s.store(ed);
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (Map.Entry<CacheStore, CacheStoreConfiguration> e : this.stores.entrySet()) {
                if (!e.getValue().fetchPersistentState()) continue;
                e.getKey().fromStream(inputStream);
                break;
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (Map.Entry<CacheStore, CacheStoreConfiguration> e : this.stores.entrySet()) {
                if (!e.getValue().fetchPersistentState()) continue;
                e.getKey().toStream(outputStream);
                break;
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                s.clear();
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) throws CacheLoaderException {
        boolean r = false;
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                r = s.remove(key) || r;
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<Object> keys) throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                s.removeAll(keys);
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeExpired() throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                s.purgeExpired();
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                s.commit(tx);
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(GlobalTransaction tx) {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                s.rollback(tx);
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(List<? extends Modification> list, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                s.prepare(list, tx, isOnePhase);
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (Map.Entry<CacheLoader, CacheLoaderConfiguration> e : this.loaders.entrySet()) {
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        InternalCacheEntry se = null;
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders.keySet()) {
                se = l.load(key);
                if (se == null) continue;
                break;
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
        return se;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        HashSet<InternalCacheEntry> set = new HashSet<InternalCacheEntry>();
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                set.addAll(s.loadAll());
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        if (numEntries < 0) {
            return this.loadAll();
        }
        HashSet<InternalCacheEntry> set = new HashSet<InternalCacheEntry>(numEntries);
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                Set<InternalCacheEntry> localSet = s.load(numEntries);
                Iterator<InternalCacheEntry> i = localSet.iterator();
                while (set.size() < numEntries && i.hasNext()) {
                    set.add(i.next());
                }
                if (set.size() < numEntries) continue;
                break;
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        HashSet<Object> set = new HashSet<Object>();
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheStore s : this.stores.keySet()) {
                set.addAll(s.loadAllKeys(keysToExclude));
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders.keySet()) {
                if (!l.containsKey(key)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
        return false;
    }

    @Override
    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders.keySet()) {
                l.start();
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders.keySet()) {
                l.stop();
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheLoader(CacheLoader loader, CacheLoaderConfiguration config) {
        this.loadersAndStoresMutex.writeLock().lock();
        try {
            this.loaders.put(loader, config);
            if (loader instanceof CacheStore) {
                this.stores.put((CacheStore)loader, (CacheStoreConfiguration)config);
            }
        }
        finally {
            this.loadersAndStoresMutex.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeIfNecessary() throws CacheLoaderException {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            for (Map.Entry<CacheStore, CacheStoreConfiguration> e : this.stores.entrySet()) {
                CacheStoreConfiguration value = e.getValue();
                if (!value.purgeOnStartup()) continue;
                e.getKey().clear();
            }
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<CacheStore, CacheStoreConfiguration> getStores() {
        this.loadersAndStoresMutex.readLock().lock();
        try {
            LinkedHashMap<CacheStore, CacheStoreConfiguration> linkedHashMap = new LinkedHashMap<CacheStore, CacheStoreConfiguration>(this.stores);
            return linkedHashMap;
        }
        finally {
            this.loadersAndStoresMutex.readLock().unlock();
        }
    }

    @Override
    public CacheStoreConfig getCacheStoreConfig() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheLoader(String loaderType) {
        this.loadersAndStoresMutex.writeLock().lock();
        try {
            HashSet<CacheLoader> toRemove = new HashSet<CacheLoader>();
            for (CacheStore cs : this.stores.keySet()) {
                String storeClass = AbstractDelegatingStore.undelegateCacheLoader(cs).getClass().getName();
                if (!storeClass.equals(loaderType)) continue;
                toRemove.add(cs);
            }
            for (CacheLoader cl : this.loaders.keySet()) {
                if (!cl.getClass().getName().equals(loaderType)) continue;
                toRemove.add(cl);
            }
            for (CacheLoader cl : toRemove) {
                try {
                    log.debugf("Stopping and removing cache loader %s", (Object)loaderType);
                    cl.stop();
                }
                catch (Exception e) {
                    log.infof("Problems shutting down cache loader %s", (Object)loaderType, (Object)e);
                }
                this.stores.remove(cl);
                this.loaders.remove(cl);
            }
        }
        finally {
            this.loadersAndStoresMutex.writeLock().unlock();
        }
    }

    public <T extends CacheLoader> List<T> getCacheLoaders(Class<T> loaderClass) {
        LinkedHashSet<CacheLoader> matchingLoaders = new LinkedHashSet<CacheLoader>();
        for (CacheStore cs : this.stores.keySet()) {
            CacheLoader ucs = AbstractDelegatingStore.undelegateCacheLoader(cs);
            if (!loaderClass.isInstance(ucs)) continue;
            matchingLoaders.add(ucs);
        }
        for (CacheLoader cl : this.loaders.keySet()) {
            if (!loaderClass.isInstance(cl)) continue;
            matchingLoaders.add(cl);
        }
        return new ArrayList(matchingLoaders);
    }
}

