/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored;

import java.util.Collection;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.anchored.configuration.AnchoredKeysConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stationary.ScaleUpWithoutStateTransferTest")
public class ScaleUpWithoutStateTransferTest
extends MultipleCacheManagersTest {
    public static final String CACHE_NAME = "testCache";
    public static final String KEY_1 = "key1";
    public static final String KEY_2 = "key2";
    public static final String KEY_3 = "key3";
    public static final String VALUE = "value";
    private StorageType storageType;

    public Object[] factory() {
        return new Object[]{new ScaleUpWithoutStateTransferTest().storageType(StorageType.OBJECT)};
    }

    public ScaleUpWithoutStateTransferTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    protected void createCacheManagers() throws Throwable {
        this.addNode();
    }

    protected String[] parameterNames() {
        return new String[]{"storageType"};
    }

    protected Object[] parameterValues() {
        return new Object[]{this.storageType};
    }

    private void addNode() {
        GlobalConfigurationBuilder managerBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        managerBuilder.defaultCacheName(CACHE_NAME);
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        cacheBuilder.clustering().cacheMode(CacheMode.REPL_SYNC).hash().numSegments(1);
        cacheBuilder.memory().storageType(this.storageType);
        ((AnchoredKeysConfigurationBuilder)cacheBuilder.addModule(AnchoredKeysConfigurationBuilder.class)).enabled(true);
        this.addClusterEnabledCacheManager(managerBuilder, cacheBuilder);
    }

    public void testEntriesAreAddedToNewestNode() {
        this.cache(0).put((Object)KEY_1, (Object)VALUE);
        DataContainer dataContainer = this.advancedCache(0).getDataContainer();
        this.assertValue(KEY_1, VALUE);
        this.assertNoValue(KEY_2);
        this.assertLocation(KEY_1, 0, VALUE);
        this.assertNoLocation(KEY_2);
        this.addNode();
        this.assertValue(KEY_1, VALUE);
        this.assertNoValue(KEY_2);
        this.cache(0).put((Object)KEY_2, (Object)VALUE);
        this.cache(0).put((Object)KEY_3, (Object)VALUE);
        this.assertValue(KEY_1, VALUE);
        this.assertValue(KEY_2, VALUE);
        this.assertValue(KEY_3, VALUE);
        TestingUtil.waitForNoRebalance((Collection)this.caches());
        this.assertLocation(KEY_1, 0, VALUE);
        this.assertLocation(KEY_2, 1, VALUE);
        this.addNode();
        this.assertValue(KEY_1, VALUE);
        this.assertValue(KEY_2, VALUE);
        this.assertValue(KEY_3, VALUE);
        TestingUtil.waitForNoRebalance((Collection)this.caches());
        this.assertLocation(KEY_1, 0, VALUE);
        this.assertLocation(KEY_2, 1, VALUE);
        this.assertLocation(KEY_3, 1, VALUE);
    }

    private void assertValue(Object key, String expectedValue) {
        for (Cache cache : this.caches()) {
            Address address = cache.getAdvancedCache().getRpcManager().getAddress();
            Object value = cache.get(key);
            AssertJUnit.assertEquals((String)("Wrong value for " + key + " on " + address), (Object)expectedValue, (Object)value);
        }
    }

    private void assertNoValue(Object key) {
        for (Cache cache : this.caches()) {
            Address address = cache.getAdvancedCache().getRpcManager().getAddress();
            Object value = cache.get(key);
            AssertJUnit.assertNull((String)("Extra value for " + key + " on " + address), (Object)value);
        }
    }

    private void assertLocation(Object key, int ownerIndex, String expectedValue) {
        List caches = this.caches();
        for (int i = 0; i < caches.size(); ++i) {
            Cache cache = (Cache)caches.get(i);
            InternalCacheEntry entry = cache.getAdvancedCache().getDataContainer().peek(key);
            Address address = cache.getAdvancedCache().getRpcManager().getAddress();
            if (i == ownerIndex) {
                AssertJUnit.assertEquals((String)("Wrong value for " + key + " on " + address), (Object)expectedValue, (Object)entry.getValue());
                continue;
            }
            AssertJUnit.assertEquals((String)("Wrong location for " + key + " on " + address), (Object)this.address(ownerIndex), (Object)entry.getValue());
        }
    }

    private void assertNoLocation(Object key) {
        List caches = this.caches();
        for (Cache cache : caches) {
            InternalCacheEntry entry = cache.getAdvancedCache().getDataContainer().peek(key);
            Address address = cache.getAdvancedCache().getRpcManager().getAddress();
            AssertJUnit.assertNull((String)("Expected no location on " + address), (Object)entry);
        }
    }
}

