/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.configuration;

import org.infinispan.anchored.configuration.AnchoredKeysConfiguration;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.ConfigurationBuilder;

public class AnchoredKeysConfigurationBuilder
implements Builder<AnchoredKeysConfiguration> {
    private final AttributeSet attributes;
    private final ConfigurationBuilder rootBuilder;

    public AnchoredKeysConfigurationBuilder(ConfigurationBuilder builder) {
        this.rootBuilder = builder;
        this.attributes = AnchoredKeysConfiguration.attributeSet();
    }

    public void enabled(boolean enabled) {
        this.attributes.attribute(AnchoredKeysConfiguration.ENABLED).set((Object)enabled);
    }

    public void validate() {
        if (!this.rootBuilder.clustering().cacheMode().isReplicated()) {
            throw new CacheConfigurationException("Anchored keys requires cache to be in replication mode");
        }
        if (this.rootBuilder.transaction().transactionMode() != null && this.rootBuilder.transaction().transactionMode().isTransactional()) {
            throw new CacheConfigurationException("Anchored keys do not support transactions");
        }
        this.rootBuilder.clustering().stateTransfer().awaitInitialTransfer(false);
    }

    public AnchoredKeysConfiguration create() {
        return new AnchoredKeysConfiguration(this.attributes);
    }

    public Builder<?> read(AnchoredKeysConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

