/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.anchored.impl.AnchorManager;
import org.infinispan.anchored.impl.AnchoredReadCommittedEntry;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.SingleKeyNonTxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.notifications.Listener;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingEntryCacheSet;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
@Scope(value=Scopes.NAMED_CACHE)
public class AnchoredFetchInterceptor<K, V>
extends BaseRpcInterceptor {
    private static final Log log = LogFactory.getLog(AnchoredFetchInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    CommandsFactory cf;
    @Inject
    EntryFactory entryFactory;
    @Inject
    DistributionManager distributionManager;
    @Inject
    ComponentRef<Cache<K, V>> cache;
    @Inject
    AnchorManager anchorManager;

    protected Log getLog() {
        return log;
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) {
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.fetchSingleContextValue(ctx, (DataCommand)command, false));
    }

    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) {
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.fetchSingleContextValue(ctx, (DataCommand)command, false));
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.fetchSingleContextValue(ctx, (DataCommand)command, true));
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.fetchSingleContextValue(ctx, (DataCommand)command, true));
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.fetchSingleContextValue(ctx, (DataCommand)command, true));
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.fetchAllContextValues(ctx, (FlagAffectedCommand)command, true));
    }

    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) {
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.fetchAllContextValues(ctx, (FlagAffectedCommand)command, false));
    }

    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) {
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) {
        return new BackingEntrySet((CacheSet)this.invokeNext(ctx, (VisitableCommand)command));
    }

    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) {
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) {
        throw new IllegalStateException("Command " + command.getClass().getName() + " is not yet supported");
    }

    private CompletionStage<Void> fetchSingleContextValue(InvocationContext ctx, DataCommand command, boolean isWrite) {
        CacheEntry ctxEntry;
        Object key = command.getKey();
        CompletionStage<CacheEntry<Object, V>> stage = this.fetchContextValue(ctx, (FlagAffectedCommand)command, key, ctxEntry = ((SingleKeyNonTxInvocationContext)ctx).getCacheEntry(), command.getSegment(), isWrite);
        if (stage == null) {
            return CompletableFutures.completedNull();
        }
        return stage.thenAccept(externalEntry -> this.entryFactory.wrapExternalEntry(ctx, key, externalEntry, true, isWrite));
    }

    private CompletionStage<Void> fetchAllContextValues(InvocationContext ctx, FlagAffectedCommand command, boolean isWrite) {
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_REMOTE_LOOKUP)) {
            return CompletableFutures.completedNull();
        }
        AggregateCompletionStage fetchStage = CompletionStages.aggregateCompletionStage();
        ArrayList stages = new ArrayList(ctx.lookedUpEntriesCount());
        ctx.forEachEntry((key, ctxEntry) -> {
            DistributionInfo distributionInfo = this.distributionManager.getCacheTopology().getDistribution(key);
            CompletionStage<CacheEntry<Object, V>> stage = this.fetchContextValue(ctx, command, (K)key, (CacheEntry<?, ?>)ctxEntry, distributionInfo.segmentId(), isWrite);
            stages.add(stage);
            if (stage != null) {
                fetchStage.dependsOn(stage);
            }
        });
        return fetchStage.freeze().thenAccept(__ -> {
            Iterator iterator = stages.iterator();
            ctx.forEachEntry((key, ctxEntry) -> {
                CompletionStage stage = (CompletionStage)iterator.next();
                if (stage != null) {
                    CacheEntry ownerEntry = (CacheEntry)CompletionStages.join((CompletionStage)stage);
                    this.entryFactory.wrapExternalEntry(ctx, key, ownerEntry, true, isWrite);
                }
            });
        });
    }

    private CompletionStage<CacheEntry<K, V>> fetchContextValue(InvocationContext ctx, FlagAffectedCommand command, K key, CacheEntry<?, ?> ctxEntry, int segment, boolean isWrite) {
        if (ctxEntry.getValue() != null) {
            return null;
        }
        if (ctxEntry.getMetadata() instanceof RemoteMetadata) {
            RemoteMetadata remoteMetadata = (RemoteMetadata)ctxEntry.getMetadata();
            Address keyLocation = remoteMetadata.getAddress();
            if (isWrite && !this.isLocalModeForced(command)) {
                Address newLocation = this.anchorManager.updateLocation(keyLocation);
                ((AnchoredReadCommittedEntry)ctxEntry).setLocation(newLocation);
            }
            DistributionInfo distributionInfo = this.distributionManager.getCacheTopology().getSegmentDistribution(segment);
            if (isWrite && !this.shouldLoad(ctx, command, distributionInfo)) {
                return null;
            }
            return this.getRemoteValue(keyLocation, key, segment, isWrite);
        }
        if (isWrite && !this.isLocalModeForced(command)) {
            Address currentWriter = this.anchorManager.getCurrentWriter();
            ((AnchoredReadCommittedEntry)ctxEntry).setLocation(currentWriter);
        }
        return null;
    }

    private CompletionStage<CacheEntry<K, V>> getRemoteValue(Address keyLocation, K key, int segment, boolean isWrite) {
        ClusteredGetCommand getCommand = this.cf.buildClusteredGetCommand(key, segment, FlagBitSets.SKIP_OWNERSHIP_CHECK);
        getCommand.setTopologyId(0);
        getCommand.setWrite(isWrite);
        FetchResponseCollector collector = new FetchResponseCollector(key);
        return this.rpcManager.invokeCommand(keyLocation, (ReplicableCommand)getCommand, collector, this.rpcManager.getSyncRpcOptions());
    }

    private class BackingIterator
    implements CloseableIterator<CacheEntry<K, V>> {
        private Iterator<CacheEntry<K, V>> iterator;

        public BackingIterator(Iterator<CacheEntry<K, V>> iterator) {
            this.iterator = iterator;
        }

        public void close() {
            if (this.iterator instanceof CloseableIterator) {
                ((CloseableIterator)this.iterator).close();
            }
        }

        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            return this.iterator.hasNext();
        }

        public CacheEntry<K, V> next() {
            if (this.iterator == null) {
                throw new NoSuchElementException();
            }
            CacheEntry localEntry = this.iterator.next();
            if (localEntry.getMetadata() instanceof RemoteMetadata) {
                RemoteMetadata remoteMetadata = (RemoteMetadata)localEntry.getMetadata();
                Address keyLocation = remoteMetadata.getAddress();
                int segment = AnchoredFetchInterceptor.this.distributionManager.getCacheTopology().getSegment(localEntry.getKey());
                return (CacheEntry)CompletionStages.join((CompletionStage)AnchoredFetchInterceptor.this.getRemoteValue(keyLocation, localEntry.getKey(), segment, false));
            }
            return localEntry;
        }

        public void remove() {
        }

        public void forEachRemaining(Consumer<? super CacheEntry<K, V>> action) {
        }
    }

    private class BackingEntrySet
    extends AbstractDelegatingEntryCacheSet<K, V>
    implements CacheSet<CacheEntry<K, V>> {
        private final CacheSet<CacheEntry<K, V>> entrySet;

        public BackingEntrySet(CacheSet<CacheEntry<K, V>> entrySet) {
            super((Cache)AnchoredFetchInterceptor.this.cache.wired(), entrySet);
            this.entrySet = entrySet;
        }

        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new BackingIterator(this.entrySet.iterator());
        }

        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4353);
        }
    }

    private static class FetchResponseCollector<K, V>
    extends ValidSingleResponseCollector<CacheEntry<K, V>> {
        private final K key;

        public FetchResponseCollector(K key) {
            this.key = key;
        }

        protected CacheEntry<K, V> withValidResponse(Address sender, ValidResponse response) {
            Object responseValue = response.getResponseValue();
            if (responseValue == null) {
                return NullCacheEntry.getInstance();
            }
            return ((InternalCacheValue)responseValue).toInternalCacheEntry(this.key);
        }

        protected CacheEntry<K, V> targetNotFound(Address sender) {
            return NullCacheEntry.getInstance();
        }
    }
}

