/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.anchored.AbstractAnchoredKeysTest;
import org.infinispan.anchored.configuration.AnchoredKeysConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.rehash.TestWriteOperation;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestDataSCI;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="anchored.AnchoredKeysOperationsTest")
public class AnchoredKeysOperationsTest
extends AbstractAnchoredKeysTest {
    public static final String CACHE_NAME = "testCache";
    private StorageType storageType;
    private boolean serverMode;

    public Object[] factory() {
        return new Object[]{new AnchoredKeysOperationsTest().storageType(StorageType.OBJECT), new AnchoredKeysOperationsTest().storageType(StorageType.BINARY), new AnchoredKeysOperationsTest().storageType(StorageType.HEAP).serverMode(true)};
    }

    @DataProvider
    public static Object[][] operations() {
        return new Object[][]{{TestWriteOperation.PUT_CREATE}, {TestWriteOperation.PUT_OVERWRITE}, {TestWriteOperation.PUT_IF_ABSENT}, {TestWriteOperation.REPLACE}, {TestWriteOperation.REPLACE_EXACT}, {TestWriteOperation.REMOVE}, {TestWriteOperation.REMOVE_EXACT}, {TestWriteOperation.PUT_MAP_CREATE}};
    }

    public AnchoredKeysOperationsTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    private Object serverMode(boolean serverMode) {
        this.serverMode = serverMode;
        return this;
    }

    protected void createCacheManagers() {
        this.addNode();
        this.addNode();
        this.addNode();
        this.waitForClusterToForm();
    }

    protected String[] parameterNames() {
        return new String[]{"storage", "server"};
    }

    protected Object[] parameterValues() {
        return new Object[]{this.storageType, this.serverMode ? "y" : null};
    }

    private Address addNode() {
        GlobalConfigurationBuilder managerBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        managerBuilder.defaultCacheName(CACHE_NAME).serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        if (this.serverMode) {
            ((PrivateGlobalConfigurationBuilder)managerBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        }
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        ControlledConsistentHashFactory.Replicated consistentHashFactory = new ControlledConsistentHashFactory.Replicated(new int[]{0, 1, 2});
        cacheBuilder.clustering().cacheMode(CacheMode.REPL_SYNC).hash().numSegments(3).consistentHashFactory((ConsistentHashFactory)consistentHashFactory);
        cacheBuilder.clustering().stateTransfer().awaitInitialTransfer(false);
        cacheBuilder.memory().storage(this.storageType);
        ((AnchoredKeysConfigurationBuilder)cacheBuilder.addModule(AnchoredKeysConfigurationBuilder.class)).enabled(true);
        EmbeddedCacheManager manager = this.addClusterEnabledCacheManager(managerBuilder, cacheBuilder);
        return manager.getAddress();
    }

    @Test(dataProvider="operations")
    public void testSingleKeyOperations(TestWriteOperation op) {
        AdvancedCache originator = this.advancedCache(0);
        for (Cache cache : this.caches()) {
            MagicKey key = new MagicKey(cache);
            if (op.getPreviousValue() != null) {
                originator.put((Object)key, op.getPreviousValue());
            }
            Object returnValue = op.perform(originator, (Object)key);
            AssertJUnit.assertEquals((Object)op.getReturnValue(), (Object)returnValue);
            this.assertValue(key, op.getValue());
            if (op.getValue() == null) continue;
            this.assertLocation(key, this.address(2), op.getValue());
        }
    }

    public void testMultiKeyOperations() {
        int i;
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>();
        HashMap<MagicKey, Object> data = new HashMap<MagicKey, Object>();
        for (i = 0; i < this.caches().size(); ++i) {
            MagicKey key2 = new MagicKey("key-" + i, this.cache(i));
            String value2 = "value-" + i;
            keys.add(key2);
            data.put(key2, value2);
        }
        for (i = 0; i < this.caches().size(); ++i) {
            MagicKey missingKey = new MagicKey("missingkey" + i, this.cache(i));
            keys.add(missingKey);
        }
        for (Cache cache : this.caches()) {
            cache.putAll(data);
            data.forEach(this::assertValue);
            data.forEach((key, value) -> this.assertLocation(key, this.address(2), value));
            AssertJUnit.assertEquals(data, (Object)cache.getAdvancedCache().getAll(data.keySet()));
            AssertJUnit.assertEquals(data.keySet(), (Object)cache.keySet());
            AssertJUnit.assertEquals(new HashSet(data.values()), new HashSet(cache.values()));
            AssertJUnit.assertEquals((int)data.size(), (int)cache.size());
            AssertJUnit.assertEquals((long)data.size(), (long)((Long)CompletionStages.join((CompletionStage)cache.sizeAsync())));
            cache.clear();
        }
    }
}

