/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.infinispan.Cache;
import org.infinispan.anchored.configuration.AnchoredKeysConfiguration;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.configuration.serializer.AbstractConfigurationSerializerTest;
import org.infinispan.counter.exception.CounterConfigurationException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="anchored.AnchoredConfigurationSerializerTest")
@CleanupAfterMethod
public class AnchoredConfigurationSerializerTest
extends AbstractConfigurationSerializerTest {
    @DataProvider
    public static Object[][] configurationFiles() {
        return new Object[][]{{Paths.get("config/anchored.xml", new String[0])}};
    }

    public void testParser() throws IOException {
        ConfigurationBuilderHolder holder = new ParserRegistry().parseFile("config/anchored.xml");
        TestingUtil.withCacheManager(() -> TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilderHolder)holder), cacheManager -> {
            Cache anchoredCache = cacheManager.getCache();
            AnchoredKeysConfiguration anchoredKeysConfiguration = (AnchoredKeysConfiguration)anchoredCache.getCacheConfiguration().module(AnchoredKeysConfiguration.class);
            AssertJUnit.assertTrue((boolean)anchoredKeysConfiguration.enabled());
        });
    }

    public void testInvalid() throws IOException {
        try {
            ConfigurationBuilderHolder holder = new ParserRegistry().parseFile("config/invalid.xml");
            AssertJUnit.fail((String)("Expected exception. " + holder));
        }
        catch (CacheConfigurationException | CounterConfigurationException e) {
            this.log.debug((Object)"Expected exception", e);
        }
    }

    @Test(dataProvider="configurationFiles")
    public void jsonSerializationTest(Path config) throws Exception {
        throw new SkipException("JSON deserialization doesn't work");
    }

    protected void compareExtraConfiguration(String name, Configuration configurationBefore, Configuration configurationAfter) {
        AnchoredKeysConfiguration module = (AnchoredKeysConfiguration)configurationAfter.module(AnchoredKeysConfiguration.class);
        AssertJUnit.assertNotNull((Object)module);
        AssertJUnit.assertTrue((boolean)module.enabled());
    }
}

