/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.anchored.impl.AbstractDelegatingWriteManyCommandHelper;
import org.infinispan.anchored.impl.AnchorManager;
import org.infinispan.anchored.impl.AnchoredReadCommittedEntry;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.WriteManyCommandHelper;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AnchoredDistributionInterceptor
extends NonTxDistributionInterceptor {
    private static final Log log = LogFactory.getLog(AnchoredDistributionInterceptor.class);
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    AnchorManager anchorManager;

    protected Object primaryReturnHandler(InvocationContext ctx, AbstractDataWriteCommand command, Object localResult) {
        if (!command.isSuccessful()) {
            if (log.isTraceEnabled()) {
                log.tracef("Skipping the replication of the conditional command as it did not succeed on primary owner (%s).", (Object)command);
            }
            return localResult;
        }
        LocalizedCacheTopology cacheTopology = this.checkTopologyId((TopologyAffectedCommand)command);
        DistributionInfo distributionInfo = cacheTopology.getSegmentDistribution(command.getSegment());
        List owners = distributionInfo.writeOwners();
        if (owners.size() == 1) {
            return localResult;
        }
        ValueMatcher originalMatcher = command.getValueMatcher();
        command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
        CommandCopier commandCopier = new CommandCopier(ctx, (VisitableCommand)command);
        assert (this.isSynchronous((FlagAffectedCommand)command));
        MapResponseCollector collector = MapResponseCollector.ignoreLeavers((boolean)this.isReplicated, (int)owners.size());
        RpcOptions rpcOptions = this.rpcManager.getSyncRpcOptions();
        CompletionStage remoteInvocation = this.rpcManager.invokeCommands(distributionInfo.writeBackups(), (Function)commandCopier, (ResponseCollector)collector, rpcOptions);
        return AnchoredDistributionInterceptor.asyncValue(remoteInvocation.handle((responses, t) -> {
            command.setValueMatcher(originalMatcher.matcherForRetry());
            CompletableFutures.rethrowExceptionIfPresent((Throwable)(t instanceof RemoteException ? t.getCause() : t));
            return localResult;
        }));
    }

    protected <C extends WriteCommand, Container, Item> Object handleReadWriteManyCommand(final InvocationContext ctx, C command, WriteManyCommandHelper<C, Item, Container> helper) throws Exception {
        AbstractDelegatingWriteManyCommandHelper wrappedHelper = new AbstractDelegatingWriteManyCommandHelper(helper){

            public WriteCommand copyForBackup(WriteCommand cmd, LocalizedCacheTopology topology, Address target, IntSet segments) {
                WriteCommand backupCommand = this.helper.copyForBackup(cmd, topology, target, segments);
                CommandCopier commandCopier = new CommandCopier(ctx, (VisitableCommand)backupCommand);
                return (WriteCommand)commandCopier.apply(target);
            }
        };
        return super.handleReadWriteManyCommand(ctx, command, (WriteManyCommandHelper)wrappedHelper);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (command.isForwarded()) {
            assert (command.getMetadata() == null || command.getMetadata().version() == null);
            HashMap valueMap = new HashMap();
            for (Map.Entry entry : command.getMap().entrySet()) {
                Object key = entry.getKey();
                CacheEntry ctxEntry = ctx.lookupEntry(key);
                if (ctxEntry != null && entry.getValue() instanceof RemoteMetadata) {
                    RemoteMetadata entryMetadata = (RemoteMetadata)entry.getValue();
                    ctxEntry.setMetadata((Metadata)entryMetadata);
                    valueMap.put(key, null);
                    continue;
                }
                valueMap.put(key, entry.getValue());
            }
            command.setMap(valueMap);
        }
        return super.visitPutMapCommand(ctx, command);
    }

    Address getKeyWriter(CacheEntry<?, ?> contextEntry) {
        Address location = ((AnchoredReadCommittedEntry)contextEntry).getLocation();
        return location != null ? location : this.rpcManager.getAddress();
    }

    class CommandCopier
    extends AbstractVisitor
    implements Function<Address, ReplicableCommand> {
        private final InvocationContext ctx;
        private final VisitableCommand command;
        private Address target;

        CommandCopier(InvocationContext ctx, VisitableCommand command) {
            this.ctx = ctx;
            this.command = command;
        }

        @Override
        public ReplicableCommand apply(Address address) {
            this.target = address;
            try {
                return (ReplicableCommand)this.command.acceptVisitor(this.ctx, (Visitor)this);
            }
            catch (Throwable throwable) {
                throw new CacheException(throwable);
            }
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
            return this.replaceWithPutRemoteMetadata(ctx, (DataWriteCommand)command);
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
            return this.replaceWithPutRemoteMetadata(ctx, (DataWriteCommand)command);
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
            return command;
        }

        private VisitableCommand replaceWithPutRemoteMetadata(InvocationContext ctx, DataWriteCommand command) {
            Object key = command.getKey();
            Address keyWriter = AnchoredDistributionInterceptor.this.getKeyWriter(ctx.lookupEntry(key));
            if (this.target.equals(keyWriter)) {
                return command;
            }
            RemoteMetadata metadata = new RemoteMetadata(keyWriter, null);
            PutKeyValueCommand copy = new PutKeyValueCommand(key, null, false, (Metadata)metadata, command.getSegment(), command.getFlagsBitSet(), command.getCommandInvocationId());
            copy.setValueMatcher(command.getValueMatcher());
            copy.setTopologyId(command.getTopologyId());
            return copy;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
            HashMap mapCopy = new HashMap(command.getMap().size() * 2);
            for (Map.Entry entry : command.getMap().entrySet()) {
                Object key = entry.getKey();
                Address keyWriter = AnchoredDistributionInterceptor.this.getKeyWriter(ctx.lookupEntry(key));
                RemoteMetadata metadata = new RemoteMetadata(keyWriter, null);
                if (!this.target.equals(keyWriter)) {
                    mapCopy.put(key, metadata);
                    continue;
                }
                mapCopy.put(key, entry.getValue());
            }
            command.setMap(mapCopy);
            return command;
        }

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) {
            throw new UnsupportedOperationException("Command type " + command.getClass() + " is not yet supported in anchored caches");
        }
    }
}

