/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.anchored.AbstractAnchoredKeysTest;
import org.infinispan.anchored.configuration.AnchoredKeysConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.op.TestWriteOperation;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="anchored.AnchoredKeysOperationsTest")
@AbstractInfinispanTest.FeatureCondition(feature="anchored-keys")
public class AnchoredKeysOperationsTest
extends AbstractAnchoredKeysTest {
    public static final String CACHE_NAME = "testCache";
    private StorageType storageType;
    private boolean serverMode;

    public Object[] factory() {
        return new Object[]{new AnchoredKeysOperationsTest().storageType(StorageType.OBJECT), new AnchoredKeysOperationsTest().storageType(StorageType.BINARY), new AnchoredKeysOperationsTest().storageType(StorageType.HEAP).serverMode(true)};
    }

    @DataProvider
    public static Object[][] operations() {
        return new Object[][]{{TestWriteOperation.PUT_CREATE}, {TestWriteOperation.PUT_OVERWRITE}, {TestWriteOperation.PUT_IF_ABSENT}, {TestWriteOperation.REPLACE}, {TestWriteOperation.REPLACE_EXACT}, {TestWriteOperation.REMOVE}, {TestWriteOperation.REMOVE_EXACT}, {TestWriteOperation.PUT_MAP_CREATE}};
    }

    public AnchoredKeysOperationsTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    private Object serverMode(boolean serverMode) {
        this.serverMode = serverMode;
        return this;
    }

    protected void createCacheManagers() {
        this.addNode();
        this.addNode();
        this.addNode();
        this.waitForClusterToForm();
    }

    protected String[] parameterNames() {
        return new String[]{"storage", "server"};
    }

    protected Object[] parameterValues() {
        return new Object[]{this.storageType, this.serverMode ? "y" : null};
    }

    private Address addNode() {
        GlobalConfigurationBuilder managerBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        managerBuilder.defaultCacheName(CACHE_NAME).serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        if (this.serverMode) {
            ((PrivateGlobalConfigurationBuilder)managerBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        }
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        ControlledConsistentHashFactory.Replicated consistentHashFactory = new ControlledConsistentHashFactory.Replicated(new int[]{0, 1, 2});
        cacheBuilder.clustering().cacheMode(CacheMode.REPL_SYNC).hash().numSegments(3).consistentHashFactory((ConsistentHashFactory)consistentHashFactory);
        cacheBuilder.clustering().stateTransfer().awaitInitialTransfer(false);
        cacheBuilder.memory().storage(this.storageType);
        ((AnchoredKeysConfigurationBuilder)cacheBuilder.addModule(AnchoredKeysConfigurationBuilder.class)).enabled(true);
        EmbeddedCacheManager manager = this.addClusterEnabledCacheManager(managerBuilder, cacheBuilder);
        return manager.getAddress();
    }

    @Test(dataProvider="operations")
    public void testSingleKeyOperations(TestWriteOperation op) {
        AdvancedCache originator = this.advancedCache(0);
        for (Cache cache : this.caches()) {
            MagicKey key = new MagicKey(cache);
            op.insertPreviousValue(originator, (Object)key);
            Object returnValue = op.perform(originator, (Object)key);
            AssertJUnit.assertEquals((Object)op.getReturnValue(), (Object)returnValue);
            this.assertValue(key, op.getValue());
            if (op.getValue() == null) continue;
            this.assertLocation(key, this.address(2), op.getValue());
        }
    }

    public void testMultiKeyOperations() {
        int i;
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>();
        HashMap<MagicKey, Object> data = new HashMap<MagicKey, Object>();
        for (i = 0; i < this.caches().size(); ++i) {
            MagicKey key2 = new MagicKey("key-" + i, this.cache(i));
            String value2 = "value-" + i;
            keys.add(key2);
            data.put(key2, value2);
        }
        for (i = 0; i < this.caches().size(); ++i) {
            MagicKey missingKey = new MagicKey("missingkey" + i, this.cache(i));
            keys.add(missingKey);
        }
        for (Cache cache : this.caches()) {
            cache.putAll(data);
            data.forEach(this::assertValue);
            data.forEach((key, value) -> this.assertLocation(key, this.address(2), value));
            AssertJUnit.assertEquals(data, (Object)cache.getAdvancedCache().getAll(data.keySet()));
            AssertJUnit.assertEquals(data.keySet(), (Object)cache.keySet());
            AssertJUnit.assertEquals(new HashSet(data.values()), new HashSet(cache.values()));
            AssertJUnit.assertEquals((int)data.size(), (int)cache.size());
            AssertJUnit.assertEquals((long)data.size(), (long)((Long)CompletionStages.join((CompletionStage)cache.sizeAsync())));
            cache.clear();
        }
    }

    public void testClusteredListener() throws InterruptedException {
        ClusteredListener listener = new ClusteredListener();
        this.cache(0).addListener((Object)listener);
        for (Cache originator : this.caches()) {
            String key = "key_" + originator.getCacheManager().getAddress();
            String value1 = "value-1";
            String value2 = "value-2";
            AssertJUnit.assertNull((Object)originator.put((Object)key, (Object)value1));
            this.assertValue(key, value1);
            AssertJUnit.assertTrue((boolean)originator.replace((Object)key, (Object)value1, (Object)value2));
            this.assertValue(key, value2);
            AssertJUnit.assertEquals((Object)value2, (Object)originator.remove((Object)key));
            CacheEntryEvent<Object, Object> createEvent = listener.pollEvent();
            AssertJUnit.assertTrue((boolean)(createEvent instanceof CacheEntryCreatedEvent));
            AssertJUnit.assertEquals((Object)key, (Object)createEvent.getKey());
            AssertJUnit.assertEquals((Object)value1, (Object)createEvent.getValue());
            CacheEntryEvent<Object, Object> replaceEvent = listener.pollEvent();
            AssertJUnit.assertTrue((boolean)(replaceEvent instanceof CacheEntryModifiedEvent));
            AssertJUnit.assertEquals((Object)key, (Object)replaceEvent.getKey());
            AssertJUnit.assertEquals((Object)value2, (Object)replaceEvent.getValue());
            CacheEntryEvent<Object, Object> removeEvent = listener.pollEvent();
            AssertJUnit.assertTrue((boolean)(removeEvent instanceof CacheEntryRemovedEvent));
            AssertJUnit.assertEquals((Object)key, (Object)removeEvent.getKey());
            AssertJUnit.assertNull((Object)removeEvent.getValue());
            AssertJUnit.assertFalse((boolean)listener.hasMoreEvents());
        }
    }

    @Listener(clustered=true)
    public class ClusteredListener {
        private BlockingQueue<CacheEntryEvent<Object, Object>> events = new LinkedBlockingDeque<CacheEntryEvent<Object, Object>>();

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        public void onEntryEvent(CacheEntryEvent<Object, Object> e) {
            log.tracef("Received event %s", e);
            this.events.add(e);
        }

        public boolean hasMoreEvents() throws InterruptedException {
            return this.events.poll(10L, TimeUnit.MILLISECONDS) != null;
        }

        public CacheEntryEvent<Object, Object> pollEvent() throws InterruptedException {
            return this.events.poll(10L, TimeUnit.SECONDS);
        }
    }
}

