/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;

public abstract class AbstractAnchoredKeysTest
extends MultipleCacheManagersTest {
    protected void assertValue(Object key, Object expectedValue) {
        for (Cache cache : this.caches()) {
            Address address = cache.getAdvancedCache().getRpcManager().getAddress();
            Object value = cache.get(key);
            AssertJUnit.assertEquals((String)("Wrong value for " + key + " on " + address), (Object)expectedValue, (Object)value);
        }
    }

    protected void assertNoValue(Object key) {
        for (Cache cache : this.caches()) {
            Address address = cache.getAdvancedCache().getRpcManager().getAddress();
            Object value = cache.get(key);
            AssertJUnit.assertNull((String)("Extra value for " + key + " on " + address), (Object)value);
        }
    }

    protected void assertLocation(Object key, Address expectedAddress, Object expectedValue) {
        for (Cache cache : this.caches()) {
            Address address = cache.getAdvancedCache().getRpcManager().getAddress();
            Object storedKey = cache.getAdvancedCache().getKeyDataConversion().toStorage(key);
            InternalCacheEntry entry = cache.getAdvancedCache().getDataContainer().peek(storedKey);
            if (address.equals(expectedAddress)) {
                Object storedValue = entry != null ? entry.getValue() : null;
                Object value = cache.getAdvancedCache().getValueDataConversion().fromStorage(storedValue);
                AssertJUnit.assertEquals((String)("Wrong value for " + key + " on " + address), (Object)expectedValue, (Object)value);
                Metadata metadata = entry != null ? entry.getMetadata() : null;
                AssertJUnit.assertFalse((String)("No location expected for " + key + " on " + address + ", got " + metadata), (boolean)(metadata instanceof RemoteMetadata));
                continue;
            }
            AssertJUnit.assertNull((String)("No value expected for key " + key + " on " + address), (Object)entry.getValue());
            Address location = ((RemoteMetadata)entry.getMetadata()).getAddress();
            AssertJUnit.assertEquals((String)("Wrong location for " + key + " on " + address), (Object)expectedAddress, (Object)location);
        }
    }

    protected void assertNoLocation(Object key) {
        List caches = this.caches();
        for (Cache cache : caches) {
            Object storageKey = cache.getAdvancedCache().getKeyDataConversion().toStorage(key);
            InternalCacheEntry entry = cache.getAdvancedCache().getDataContainer().peek(storageKey);
            Address address = cache.getAdvancedCache().getRpcManager().getAddress();
            AssertJUnit.assertNull((String)("Expected no location on " + address), (Object)entry);
        }
    }
}

