/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored;

import java.util.Collection;
import org.infinispan.anchored.AbstractAnchoredKeysTest;
import org.infinispan.anchored.configuration.AnchoredKeysConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="anchored.AnchoredKeysScalingTest")
@CleanupAfterMethod
@AbstractInfinispanTest.FeatureCondition(feature="anchored-keys")
public class AnchoredKeysScalingTest
extends AbstractAnchoredKeysTest {
    public static final String CACHE_NAME = "testCache";
    public static final String KEY_1 = "key1";
    public static final String KEY_2 = "key2";
    public static final String KEY_3 = "key3";
    public static final String VALUE_1 = "value1";
    public static final String VALUE_2 = "value2";
    private StorageType storageType;

    public Object[] factory() {
        return new Object[]{new AnchoredKeysScalingTest().storageType(StorageType.OBJECT), new AnchoredKeysScalingTest().storageType(StorageType.BINARY), new AnchoredKeysScalingTest().storageType(StorageType.OFF_HEAP)};
    }

    public AnchoredKeysScalingTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    protected void createCacheManagers() {
        this.addNode();
    }

    protected String[] parameterNames() {
        return new String[]{"storage"};
    }

    protected Object[] parameterValues() {
        return new Object[]{this.storageType};
    }

    private Address addNode() {
        GlobalConfigurationBuilder managerBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        managerBuilder.defaultCacheName(CACHE_NAME);
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        cacheBuilder.clustering().cacheMode(CacheMode.REPL_SYNC).hash().numSegments(4);
        cacheBuilder.clustering().stateTransfer().awaitInitialTransfer(false);
        cacheBuilder.memory().storage(this.storageType);
        ((AnchoredKeysConfigurationBuilder)cacheBuilder.addModule(AnchoredKeysConfigurationBuilder.class)).enabled(true);
        EmbeddedCacheManager manager = this.addClusterEnabledCacheManager(managerBuilder, cacheBuilder);
        return manager.getAddress();
    }

    public void testMultipleJoinsAndLeave() {
        Address A = this.address(0);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_1);
        this.assertValue(KEY_1, VALUE_1);
        this.assertNoValue(KEY_2);
        this.assertLocation(KEY_1, A, VALUE_1);
        this.assertNoLocation(KEY_2);
        Address B = this.addNode();
        this.waitForClusterToForm();
        this.assertValue(KEY_1, VALUE_1);
        this.assertNoValue(KEY_2);
        this.cache(0).put((Object)KEY_2, (Object)VALUE_1);
        this.assertValue(KEY_1, VALUE_1);
        this.assertValue(KEY_2, VALUE_1);
        this.assertNoValue(KEY_3);
        TestingUtil.waitForNoRebalance((Collection)this.caches());
        this.assertLocation(KEY_1, A, VALUE_1);
        this.assertLocation(KEY_2, B, VALUE_1);
        this.assertNoLocation(KEY_3);
        Address C = this.addNode();
        this.waitForClusterToForm();
        this.assertValue(KEY_1, VALUE_1);
        this.assertValue(KEY_2, VALUE_1);
        this.assertNoValue(KEY_3);
        this.cache(0).put((Object)KEY_3, (Object)VALUE_1);
        this.assertValue(KEY_1, VALUE_1);
        this.assertValue(KEY_2, VALUE_1);
        this.assertValue(KEY_3, VALUE_1);
        TestingUtil.waitForNoRebalance((Collection)this.caches());
        this.assertLocation(KEY_1, A, VALUE_1);
        this.assertLocation(KEY_2, B, VALUE_1);
        this.assertLocation(KEY_3, C, VALUE_1);
        this.killMember(2);
        this.waitForClusterToForm();
        this.assertNoValue(KEY_3);
        this.assertLocation(KEY_3, C, null);
        this.cache(0).put((Object)KEY_3, (Object)VALUE_2);
        this.assertValue(KEY_3, VALUE_2);
        this.assertLocation(KEY_3, B, VALUE_2);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_2);
        this.assertValue(KEY_1, VALUE_2);
        this.assertLocation(KEY_1, A, VALUE_2);
    }
}

