/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.async;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.infinispan.api.async.AsyncContainer;
import org.infinispan.api.async.AsyncQueryResult;
import org.infinispan.api.async.AsyncStreamingCache;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.events.cache.CacheContinuousQueryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.tasks.EntryConsumerTask;
import org.infinispan.api.configuration.CacheConfiguration;

public interface AsyncCache<K, V> {
    public String name();

    public CompletionStage<CacheConfiguration> configuration();

    public AsyncContainer container();

    public CompletionStage<V> get(K var1);

    public CompletionStage<Boolean> putIfAbsent(K var1, V var2);

    public CompletionStage<V> put(K var1, V var2);

    public CompletionStage<Void> set(K var1, V var2);

    public CompletionStage<Boolean> remove(K var1);

    public CompletionStage<V> getAndRemove(K var1);

    public Flow.Publisher<K> keys();

    public Flow.Publisher<? extends CacheEntry<K, V>> entries();

    public CompletionStage<Void> putAll(Map<K, V> var1);

    public Flow.Publisher<? extends CacheEntry<K, V>> getMany(Set<K> var1);

    public Flow.Publisher<K> removeAll(Set<K> var1);

    public Flow.Publisher<? extends CacheEntry<K, V>> getAndRemoveAll(Set<K> var1);

    public CompletionStage<Long> estimateSize();

    public CompletionStage<Void> clear();

    public <R> CompletionStage<AsyncQueryResult<R>> find(String var1);

    public <R> Flow.Publisher<CacheContinuousQueryEvent<K, R>> findContinuously(String var1);

    default public Flow.Publisher<CacheEntryEvent<K, V>> listen(CacheEntryEventType ... types) {
        return this.listen(new CacheListenerOptions(), types);
    }

    public Flow.Publisher<CacheEntryEvent<K, V>> listen(CacheListenerOptions var1, CacheEntryEventType ... var2);

    public CompletionStage<Void> process(EntryConsumerTask<K, V> var1);

    public AsyncStreamingCache<K> streaming();
}

