/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mutiny;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.api.Experimental;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryMetadata;
import org.infinispan.api.common.events.cache.CacheContinuousQueryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.tasks.EntryConsumerTask;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.mutiny.MutinyContainer;
import org.infinispan.api.mutiny.MutinyQuery;
import org.infinispan.api.mutiny.MutinyStreamingCache;
import org.infinispan.api.mutiny.MutinyWriteResult;

@Experimental
public interface MutinyCache<K, V> {
    public String name();

    public Uni<CacheConfiguration> configuration();

    public MutinyContainer container();

    public Uni<V> get(K var1);

    public Uni<Boolean> putIfAbsent(K var1, V var2);

    public Uni<V> put(K var1, V var2);

    public Uni<Void> set(K var1, V var2);

    public Uni<Boolean> remove(K var1);

    public Uni<V> getAndRemove(K var1);

    public Multi<K> keys();

    public Multi<? extends CacheEntry<K, V>> entries();

    public Multi<? extends CacheEntry<K, V>> getMany(List<K> var1);

    public Multi<? extends CacheEntry<K, V>> getMany(K ... var1);

    public Multi<MutinyWriteResult<K>> put(Multi<CacheEntry<K, V>> var1);

    public Multi<MutinyWriteResult<K>> put(List<CacheEntry<K, V>> var1);

    public Multi<MutinyWriteResult<K>> put(Map<K, V> var1, CacheEntryMetadata var2);

    public Multi<MutinyWriteResult<K>> put(Map<K, V> var1);

    public Multi<K> removeMany(Multi<K> var1);

    public Multi<? extends CacheEntry<K, V>> getAndRemoveMany(Multi<K> var1);

    public Uni<Long> estimateSize();

    public Uni<Void> clear();

    public <R> Multi<R> find(String var1);

    public <R> MutinyQuery<R> query(String var1);

    public <R> Multi<CacheContinuousQueryEvent<K, R>> queryContinuously(String var1);

    default public Multi<? extends CacheEntryEvent<K, V>> listen(CacheEntryEventType ... types) {
        return this.listen(new CacheListenerOptions(), types);
    }

    public Multi<? extends CacheEntryEvent<K, V>> listen(CacheListenerOptions var1, CacheEntryEventType ... var2);

    public Multi<MutinyWriteResult> process(Set<K> var1, EntryConsumerTask<K, V> var2);

    public Multi<MutinyWriteResult> process(String var1, EntryConsumerTask<K, V> var2);

    public MutinyStreamingCache<K> streaming();
}

