/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.sync;

import java.util.Map;
import java.util.Set;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CloseableIterable;
import org.infinispan.api.common.tasks.EntryConsumerTask;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.sync.SyncContainer;
import org.infinispan.api.sync.SyncQuery;
import org.infinispan.api.sync.SyncQueryResult;
import org.infinispan.api.sync.SyncStreamingCache;
import org.infinispan.api.sync.events.cache.SyncCacheContinuousQueryListener;
import org.infinispan.api.sync.events.cache.SyncCacheEntryListener;

public interface SyncCache<K, V> {
    public String name();

    public CacheConfiguration configuration();

    public SyncContainer container();

    public V get(K var1);

    public V put(K var1, V var2);

    public void set(K var1, V var2);

    public boolean putIfAbsent(K var1, V var2);

    public boolean remove(K var1);

    public V getAndRemove(K var1);

    public CloseableIterable<K> keys();

    public CloseableIterable<? extends CacheEntry<K, V>> entries();

    public void putAll(Map<K, V> var1);

    public Map<K, V> getAll(Set<K> var1);

    public Set<K> removeAll(Set<K> var1);

    public Map<K, V> getAndRemoveAll(Set<K> var1);

    public long estimateSize();

    public void clear();

    public <R> Iterable<SyncQueryResult<R>> find(String var1);

    public <R> SyncQuery<R> query(String var1);

    public <R> AutoCloseable listen(SyncQuery<R> var1, SyncCacheContinuousQueryListener<K, V> var2);

    public AutoCloseable listen(SyncCacheEntryListener<K, V> var1);

    public void process(EntryConsumerTask<K, V> var1);

    public SyncStreamingCache<K> streaming();
}

