/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.api.DemoEnumFlag;
import org.infinispan.api.DemoEnumFlags;
import org.infinispan.api.Infinispan;
import org.infinispan.api.async.AsyncCache;
import org.infinispan.api.async.AsyncQueryResult;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.Flags;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;

public class ASyncCacheDemo {
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);

    public void cache() throws ExecutionException, InterruptedException {
        try (Infinispan infinispan = Infinispan.create((String)"file:///path/to/infinispan.xml");){
            CompletionStage cacheCompletionStage = infinispan.async().caches().get("mycache");
            AsyncCache mycache = (AsyncCache)ASyncCacheDemo.await(cacheCompletionStage);
            ASyncCacheDemo.await(mycache.set((Object)"key", (Object)"value"));
            String value = (String)ASyncCacheDemo.await(mycache.get((Object)"key"));
            CacheEntry previous = (CacheEntry)ASyncCacheDemo.await(mycache.put((Object)"key", (Object)"newvalue"));
            ASyncCacheDemo.await(mycache.set((Object)"key", (Object)"anothervalue", CacheWriteOptions.writeOptions().lifespan(Duration.ofHours(1L)).timeout(Duration.ofMillis(500L)).build()));
            value = (String)ASyncCacheDemo.await(mycache.get((Object)"key", CacheOptions.options().timeout(Duration.ofMillis(500L)).flags((Flags)DemoEnumFlags.of(DemoEnumFlag.skipLoad(), DemoEnumFlag.skipNotification())).build()));
            CacheEntry entry = (CacheEntry)ASyncCacheDemo.await(mycache.getEntry((Object)"key"));
            ASyncCacheDemo.await(mycache.setIfAbsent((Object)"anotherkey", (Object)"value"));
            CacheEntry existing = (CacheEntry)ASyncCacheDemo.await(mycache.putIfAbsent((Object)"anotherkey", (Object)"anothervalue"));
            boolean removed = (Boolean)ASyncCacheDemo.await(mycache.remove((Object)"anotherkey"));
            ((AsyncQueryResult)ASyncCacheDemo.await(mycache.query("age > :age").param("age", (Object)5).skip(5L).limit(10).find())).results().subscribe(new NullSubscriber());
            ASyncCacheDemo.await(mycache.query("delete from person where age > :age").param("age", (Object)80).skip(5L).limit(10).execute());
            mycache.query("age > :age").param("age", (Object)80).skip(5L).limit(10).process((e, ctx) -> null).subscribe(new NullSubscriber());
            mycache.keys().subscribe(new NullSubscriber());
            mycache.entries().subscribe(new NullSubscriber());
            mycache.process(Set.of("k1", "k2"), (entries, context) -> null);
            ASyncCacheDemo.await(mycache.putAll(Map.of("key1", "value1", "key2", "value2")));
            mycache.getAll(Set.of("key1", "key2")).subscribe(new NullSubscriber());
            mycache.listen(new CacheListenerOptions().clustered(), new CacheEntryEventType[]{CacheEntryEventType.CREATED}).subscribe(new NullSubscriber());
            ASyncCacheDemo.await(infinispan.async().batch(async -> async.caches().get("mycache").thenCompose(c -> c.set((Object)"k1", (Object)"v1").thenApply(v -> c)).thenCompose(c -> c.set((Object)"k2", (Object)"v2"))));
        }
    }

    static <T> T await(CompletionStage<T> cf) {
        return ASyncCacheDemo.await(cf.toCompletableFuture());
    }

    static <T> T await(CompletableFuture<T> cf) {
        try {
            return cf.get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    static class NullSubscriber<T>
    implements Flow.Subscriber<T> {
        NullSubscriber() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
        }

        @Override
        public void onNext(T item) {
        }

        @Override
        public void onError(Throwable throwable) {
        }

        @Override
        public void onComplete() {
        }
    }
}

