/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.uni.UniBlockingAwait;
import java.time.Duration;
import java.util.Map;
import org.infinispan.api.DemoEnumFlag;
import org.infinispan.api.DemoEnumFlags;
import org.infinispan.api.Infinispan;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.Flags;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.mutiny.MutinyCache;

public class MutinyCacheDemo {
    public void testAPI() {
        try (Infinispan infinispan = Infinispan.create((String)"file:///path/to/infinispan.xml");){
            Uni cacheUni = infinispan.mutiny().caches().get("mycache");
            MutinyCache mycache = (MutinyCache)MutinyCacheDemo.await(cacheUni);
            MutinyCacheDemo.await(mycache.set((Object)"key", (Object)"value"));
            String value = (String)MutinyCacheDemo.await(mycache.get((Object)"key"));
            CacheEntry previous = (CacheEntry)MutinyCacheDemo.await(mycache.put((Object)"key", (Object)"newvalue"));
            MutinyCacheDemo.await(mycache.set((Object)"key", (Object)"anothervalue", CacheWriteOptions.writeOptions().lifespan(Duration.ofHours(1L)).timeout(Duration.ofMillis(500L)).build()));
            value = (String)MutinyCacheDemo.await(mycache.get((Object)"key", CacheOptions.options().timeout(Duration.ofMillis(500L)).flags((Flags)DemoEnumFlags.of(DemoEnumFlag.skipLoad(), DemoEnumFlag.skipNotification())).build()));
            CacheEntry entry = (CacheEntry)MutinyCacheDemo.await(mycache.getEntry((Object)"key"));
            mycache.query("age > :age").param("age", (Object)5).skip(5L).limit(10).find().subscribe();
            MutinyCacheDemo.await(mycache.query("delete from person where age > :age").param("age", (Object)80).skip(5L).limit(10).execute());
            mycache.query("age > :age").param("age", (Object)80).skip(5L).limit(10).process((entries, ctx) -> null).subscribe();
            mycache.keys().subscribe();
            mycache.entries().subscribe();
            mycache.putAll(Map.of("key1", "value1", "key2", "value2")).subscribe();
            mycache.getAll((Object[])new String[]{"key1", "key2"}).subscribe();
            mycache.listen(new CacheListenerOptions().clustered(), new CacheEntryEventType[]{CacheEntryEventType.CREATED}).subscribe();
        }
    }

    public static <T> T await(Uni<T> uni) {
        return (T)UniBlockingAwait.await(uni, (Duration)Duration.ofHours(1L), null);
    }
}

