/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.infinispan.commons.logging.BasicLogFactory;
import org.infinispan.commons.util.EnumerationList;
import org.infinispan.commons.util.Util;
import org.jboss.logging.BasicLogger;

public class FileLookup {
    private static final BasicLogger log = BasicLogFactory.getLog(FileLookup.class);

    public InputStream lookupFile(String filename, ClassLoader cl) {
        try {
            return this.lookupFileStrict(filename, cl);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public InputStream lookupFileStrict(String filename, ClassLoader cl) throws FileNotFoundException {
        InputStream is;
        InputStream inputStream = is = filename == null || filename.length() == 0 ? null : this.getAsInputStreamFromClassLoader(filename, cl);
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debugf("Unable to find file %s in classpath; searching for this file on the filesystem instead.", (Object)filename);
            }
            return new FileInputStream(filename);
        }
        return is;
    }

    public InputStream lookupFileStrict(URI uri, ClassLoader cl) throws FileNotFoundException {
        return new FileInputStream(new File(uri));
    }

    public URL lookupFileLocation(String filename, ClassLoader cl) {
        File f;
        URL u = this.getAsURLFromClassLoader(filename, cl);
        if (u == null && (f = new File(filename)).exists()) {
            try {
                u = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return u;
    }

    public Collection<URL> lookupFileLocations(String filename, ClassLoader cl) throws IOException {
        Collection<URL> u = this.getAsURLsFromClassLoader(filename, cl);
        File f = new File(filename);
        if (f.exists()) {
            try {
                u.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return u;
    }

    private InputStream getAsInputStreamFromClassLoader(String filename, ClassLoader appClassLoader) {
        for (ClassLoader cl : Util.getClassLoaders(appClassLoader)) {
            if (cl == null) continue;
            try {
                InputStream is = cl.getResourceAsStream(filename);
                if (is == null) continue;
                return is;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return null;
    }

    private URL getAsURLFromClassLoader(String filename, ClassLoader userClassLoader) {
        for (ClassLoader cl : Util.getClassLoaders(userClassLoader)) {
            if (cl == null) continue;
            try {
                URL url = cl.getResource(filename);
                if (url == null) continue;
                return url;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return null;
    }

    private Collection<URL> getAsURLsFromClassLoader(String filename, ClassLoader userClassLoader) throws IOException {
        HashSet<URL> urls = new HashSet<URL>(4);
        for (ClassLoader cl : Util.getClassLoaders(userClassLoader)) {
            if (cl == null) continue;
            try {
                urls.addAll(new EnumerationList<URL>(cl.getResources(filename)));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return urls;
    }
}

