/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class FileDescriptorSource {
    private static final String ENCODING = "UTF-8";
    private static final int BUFFER_SIZE = 1024;
    private final Map<String, char[]> descriptors = new ConcurrentHashMap<String, char[]>();

    public void addProtoFiles(String ... classpathResources) throws IOException {
        for (String classpathResource : classpathResources) {
            if (classpathResource == null) {
                throw new IllegalArgumentException("classpathResource cannot be null");
            }
            String absPath = classpathResource.startsWith("/") ? classpathResource : "/" + classpathResource;
            InputStream resourceAsStream = this.getClass().getResourceAsStream(absPath);
            if (resourceAsStream == null) {
                throw new IOException("Resource not found in class path : " + classpathResource);
            }
            String name = Paths.get(classpathResource, new String[0]).getFileName().toString();
            this.addProtoFile(name, resourceAsStream);
        }
    }

    public void addProtoFile(String name, String contents) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        this.descriptors.put(name, contents.toCharArray());
    }

    public void addProtoFile(String name, InputStream contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        this.descriptors.put(name, this.toCharArray(contents));
    }

    public void addProtoFile(String name, Reader contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        this.descriptors.put(name, this.toCharArray(contents));
    }

    public void addProtoFiles(File ... protofiles) throws IOException {
        for (File protofile : protofiles) {
            if (protofile == null) {
                throw new IllegalArgumentException("protofile cannot be null");
            }
            this.descriptors.put(protofile.getName(), this.toCharArray(protofile));
        }
    }

    public static FileDescriptorSource fromResources(String ... classPathResources) throws IOException {
        FileDescriptorSource fileDescriptorSource = new FileDescriptorSource();
        fileDescriptorSource.addProtoFiles(classPathResources);
        return fileDescriptorSource;
    }

    public static FileDescriptorSource fromFiles(File ... files) throws IOException {
        FileDescriptorSource fileDescriptorSource = new FileDescriptorSource();
        fileDescriptorSource.addProtoFiles(files);
        return fileDescriptorSource;
    }

    public static FileDescriptorSource fromString(String name, String protoSource) {
        FileDescriptorSource fileDescriptorSource = new FileDescriptorSource();
        fileDescriptorSource.addProtoFile(name, protoSource);
        return fileDescriptorSource;
    }

    public Map<String, char[]> getFileDescriptors() {
        return Collections.unmodifiableMap(this.descriptors);
    }

    private char[] toCharArray(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            char[] cArray = this.toCharArray(is);
            return cArray;
        }
    }

    private char[] toCharArray(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is, ENCODING);){
            char[] cArray = this.toCharArray(reader);
            return cArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] toCharArray(Reader reader) throws IOException {
        try {
            int count;
            CharArrayWriter writer = new CharArrayWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            char[] cArray = writer.toCharArray();
            return cArray;
        }
        finally {
            reader.close();
        }
    }
}

