/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.Configuration;
import org.infinispan.protostream.DescriptorParser;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.MessageMarshallerDelegate;
import org.infinispan.protostream.impl.RawProtobufMarshallerDelegate;
import org.infinispan.protostream.impl.parser.SquareProtoParser;

public final class SerializationContextImpl
implements SerializationContext {
    private final Configuration configuration;
    private final DescriptorParser parser = new SquareProtoParser();
    private Map<String, FileDescriptor> fileDescriptors = new ConcurrentHashMap<String, FileDescriptor>();
    private Map<String, Descriptor> messageDescriptors = new ConcurrentHashMap<String, Descriptor>();
    private Map<String, EnumDescriptor> enumDescriptors = new ConcurrentHashMap<String, EnumDescriptor>();
    private Map<String, BaseMarshallerDelegate<?>> marshallersByName = new ConcurrentHashMap();
    private Map<Class<?>, BaseMarshallerDelegate<?>> marshallersByClass = new ConcurrentHashMap();

    public SerializationContextImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void registerProtoFiles(FileDescriptorSource source) throws IOException, DescriptorParserException {
        Map<String, FileDescriptor> parse = this.parser.parse(source);
        for (FileDescriptor d : parse.values()) {
            this.registerProtofile(d);
        }
    }

    @Override
    public void registerProtofiles(String ... classpathResource) throws IOException, DescriptorParserException {
        FileDescriptorSource fileDescriptorSource = new FileDescriptorSource();
        fileDescriptorSource.addProtoFiles(classpathResource);
        this.registerProtoFiles(fileDescriptorSource);
    }

    public void registerProtofile(FileDescriptor fileDescriptor) {
        this.fileDescriptors.put(fileDescriptor.getName(), fileDescriptor);
        this.registerMessageDescriptors(fileDescriptor.getMessageTypes());
        this.registerEnumDescriptors(fileDescriptor.getEnumTypes());
    }

    private void registerMessageDescriptors(List<Descriptor> messageTypes) {
        for (Descriptor d : messageTypes) {
            this.messageDescriptors.put(d.getFullName(), d);
            this.registerMessageDescriptors(d.getNestedTypes());
            this.registerEnumDescriptors(d.getEnumTypes());
        }
    }

    private void registerEnumDescriptors(List<EnumDescriptor> enumTypes) {
        for (EnumDescriptor e : enumTypes) {
            this.enumDescriptors.put(e.getFullName(), e);
        }
    }

    @Override
    public Descriptor getMessageDescriptor(String fullName) {
        Descriptor descriptor = this.messageDescriptors.get(fullName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Message descriptor not found : " + fullName);
        }
        return descriptor;
    }

    @Override
    public EnumDescriptor getEnumDescriptor(String fullName) {
        EnumDescriptor descriptor = this.enumDescriptors.get(fullName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Enum descriptor not found : " + fullName);
        }
        return descriptor;
    }

    @Override
    public <T> void registerMarshaller(BaseMarshaller<T> marshaller) {
        BaseMarshallerDelegate marshallerDelegate;
        if (marshaller instanceof EnumMarshaller) {
            if (!Enum.class.isAssignableFrom(marshaller.getJavaClass())) {
                throw new IllegalArgumentException("Invalid enum marshaller (the produced class is not an Enum) : " + marshaller);
            }
            EnumDescriptor enumDescriptor = this.getEnumDescriptor(marshaller.getTypeName());
            marshallerDelegate = new EnumMarshallerDelegate((EnumMarshaller)marshaller, enumDescriptor);
        } else if (marshaller instanceof RawProtobufMarshaller) {
            marshallerDelegate = new RawProtobufMarshallerDelegate((RawProtobufMarshaller)marshaller, this);
        } else {
            Descriptor messageDescriptor = this.getMessageDescriptor(marshaller.getTypeName());
            marshallerDelegate = new MessageMarshallerDelegate((MessageMarshaller)marshaller, messageDescriptor);
        }
        this.marshallersByName.put(marshaller.getTypeName(), marshallerDelegate);
        this.marshallersByClass.put(marshaller.getJavaClass(), marshallerDelegate);
    }

    @Override
    public boolean canMarshall(Class clazz) {
        return this.marshallersByClass.containsKey(clazz);
    }

    @Override
    public boolean canMarshall(String descriptorFullName) {
        return this.messageDescriptors.containsKey(descriptorFullName) || this.enumDescriptors.containsKey(descriptorFullName);
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(String descriptorFullName) {
        return this.getMarshallerDelegate(descriptorFullName).getMarshaller();
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        return this.getMarshallerDelegate(clazz).getMarshaller();
    }

    <T> BaseMarshallerDelegate<T> getMarshallerDelegate(String descriptorFullName) {
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByName.get(descriptorFullName);
        if (marshallerDelegate == null) {
            throw new IllegalArgumentException("No marshaller registered for " + descriptorFullName);
        }
        return marshallerDelegate;
    }

    <T> BaseMarshallerDelegate<T> getMarshallerDelegate(Class<T> clazz) {
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByClass.get(clazz);
        if (marshallerDelegate == null) {
            throw new IllegalArgumentException("No marshaller registered for " + clazz);
        }
        return marshallerDelegate;
    }
}

