/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser;

import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.ProtoSchemaParser;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.protostream.DescriptorParser;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.parser.mappers.ProtofileMapper;

public final class SquareProtoParser
implements DescriptorParser {
    @Override
    public Map<String, FileDescriptor> parse(FileDescriptorSource fileDescriptorSource) throws IOException, DescriptorParserException {
        Map<String, ProtoFile> fileMap = this.parseInternal(fileDescriptorSource.getFileDescriptors());
        HashMap<String, FileDescriptor> fileDescriptorMap = new HashMap<String, FileDescriptor>(fileMap.size());
        for (String fileName : fileMap.keySet()) {
            if (fileDescriptorMap.containsKey(fileName)) continue;
            FileDescriptor mapped = new ProtofileMapper(fileMap).map(fileMap.get(fileName));
            fileDescriptorMap.put(fileName, mapped);
        }
        return fileDescriptorMap;
    }

    private Map<String, ProtoFile> parseInternal(Map<String, char[]> input) throws IOException, DescriptorParserException {
        LinkedHashMap<String, ProtoFile> fileMap = new LinkedHashMap<String, ProtoFile>();
        for (Map.Entry<String, char[]> entry : input.entrySet()) {
            CharArrayReader reader = new CharArrayReader(entry.getValue());
            ProtoFile protoFile = ProtoSchemaParser.parse((String)entry.getKey(), (Reader)reader);
            fileMap.put(this.getFullName(protoFile), protoFile);
        }
        return fileMap;
    }

    private String getFullName(ProtoFile protoFile) {
        String fileName = protoFile.getFileName();
        String packageName = protoFile.getPackageName();
        if (packageName == null || packageName.isEmpty()) {
            return fileName;
        }
        return packageName.replaceAll("\\.", "/").concat("/").concat(fileName);
    }
}

