/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser.mappers;

import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.MessageType;
import java.util.List;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.impl.parser.mappers.Mapper;
import org.infinispan.protostream.impl.parser.mappers.Mappers;

class MessageTypeMapper
implements Mapper<MessageType, Descriptor> {
    MessageTypeMapper() {
    }

    @Override
    public Descriptor map(MessageType type) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        List nestedTypes = type.getNestedTypes();
        List<MessageType> nestedMessageTypes = Mappers.filter(nestedTypes, MessageType.class);
        List<EnumType> enumTypes = Mappers.filter(nestedTypes, EnumType.class);
        List fields = type.getFields();
        List options = type.getOptions();
        String name = type.getName();
        return new Descriptor.Builder().withFullName(fullyQualifiedName).withName(name).withFields(Mappers.FIELD_LIST_MAPPER.map(fields)).withEnumTypes(Mappers.ENUM_LIST_MAPPER.map(enumTypes)).withNestedTypes(Mappers.MESSAGE_LIST_MAPPER.map(nestedMessageTypes)).withOptions(Mappers.OPTION_LIST_MAPPER.map(options)).build();
    }
}

