/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.query.RemoteQueryBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.impl.BaseQueryFactory;
import org.infinispan.query.remote.client.MarshallerRegistration;

public final class RemoteQueryFactory
extends BaseQueryFactory<Query> {
    private final RemoteCacheImpl cache;
    private final SerializationContext serializationContext;

    public RemoteQueryFactory(RemoteCacheImpl cache) {
        this.serializationContext = ProtoStreamMarshaller.getSerializationContext(cache.getRemoteCacheManager());
        this.cache = cache;
        try {
            MarshallerRegistration.registerMarshallers((SerializationContext)this.serializationContext);
        }
        catch (Exception e) {
            throw new HotRodClientException("Failed to initialise serialization context", e);
        }
    }

    public QueryBuilder<Query> from(Class entityType) {
        String typeName = this.serializationContext.getMarshaller(entityType).getTypeName();
        return new RemoteQueryBuilder(this.cache, this.serializationContext, typeName);
    }

    public QueryBuilder<Query> from(String entityType) {
        return new RemoteQueryBuilder(this.cache, this.serializationContext, entityType);
    }
}

