/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Option;

public final class EnumDescriptor {
    private final String name;
    private final String fullName;
    private final List<Option> options;
    private final List<EnumValueDescriptor> values;
    private final Map<Integer, EnumValueDescriptor> valueByNumber = new HashMap<Integer, EnumValueDescriptor>();
    private final Map<String, EnumValueDescriptor> valueByName = new HashMap<String, EnumValueDescriptor>();
    private FileDescriptor fileDescriptor;

    private EnumDescriptor(Builder builder) {
        this.name = builder.name;
        this.fullName = builder.fullName;
        this.options = Collections.unmodifiableList(builder.options);
        this.values = Collections.unmodifiableList(builder.values);
        for (EnumValueDescriptor value : this.values) {
            this.valueByNumber.put(value.getNumber(), value);
            this.valueByName.put(value.getName(), value);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<EnumValueDescriptor> getValues() {
        return this.values;
    }

    public EnumValueDescriptor findValueByNumber(int number) {
        return this.valueByNumber.get(number);
    }

    public EnumValueDescriptor findValueByName(String name) {
        return this.valueByName.get(name);
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
        for (EnumValueDescriptor valueDescriptor : this.values) {
            valueDescriptor.setFileDescriptor(fileDescriptor);
        }
    }

    public static class Builder {
        private String name;
        private String fullName;
        private List<Option> options;
        private List<EnumValueDescriptor> values;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withValues(List<EnumValueDescriptor> values) {
            this.values = values;
            return this;
        }

        public EnumDescriptor build() {
            return new EnumDescriptor(this);
        }
    }
}

