/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.config.AnnotationConfig;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;

public final class AnnotationAttributeConfig {
    private final String name;
    private final boolean isMultiple;
    private final Object defaultValue;
    private final AttributeType type;
    private final Set<String> allowedValues;

    private AnnotationAttributeConfig(String name, boolean isMultiple, Object defaultValue, AttributeType type, Set<String> allowedValues) {
        this.name = name;
        this.isMultiple = isMultiple;
        this.defaultValue = defaultValue;
        this.type = type;
        this.allowedValues = allowedValues;
    }

    public String name() {
        return this.name;
    }

    public boolean multiple() {
        return this.isMultiple;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public AttributeType type() {
        return this.type;
    }

    public Set<String> allowedValues() {
        return this.allowedValues;
    }

    public static final class Builder<DescriptorType extends AnnotatedDescriptor> {
        private final AnnotationConfig.Builder<DescriptorType> parentBuilder;
        private final String name;
        private boolean isMultiple;
        private Object defaultValue;
        private AttributeType type = AttributeType.STRING;
        private String[] allowedValues;

        Builder(AnnotationConfig.Builder<DescriptorType> parentBuilder, String name) {
            this.parentBuilder = parentBuilder;
            this.name = name;
        }

        public Builder<DescriptorType> multiple(boolean isMultiple) {
            this.isMultiple = isMultiple;
            return this;
        }

        public Builder<DescriptorType> defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<DescriptorType> annotationType(String ... allowedAnnotations) {
            this.type = AttributeType.ANNOTATION;
            this.allowedValues = allowedAnnotations;
            return this;
        }

        public Builder<DescriptorType> identifierType(String ... allowedValues) {
            this.type = AttributeType.IDENTIFIER;
            this.allowedValues = allowedValues;
            return this;
        }

        public Builder<DescriptorType> stringType(String ... allowedValues) {
            this.type = AttributeType.STRING;
            this.allowedValues = allowedValues;
            return this;
        }

        public Builder<DescriptorType> characterType() {
            this.type = AttributeType.CHARACTER;
            this.allowedValues = null;
            return this;
        }

        public Builder<DescriptorType> booleanType() {
            this.type = AttributeType.BOOLEAN;
            this.allowedValues = null;
            return this;
        }

        public Builder<DescriptorType> intType() {
            this.type = AttributeType.INT;
            this.allowedValues = null;
            return this;
        }

        public Builder<DescriptorType> longType() {
            this.type = AttributeType.LONG;
            this.allowedValues = null;
            return this;
        }

        public Builder<DescriptorType> floatType() {
            this.type = AttributeType.FLOAT;
            this.allowedValues = null;
            return this;
        }

        public Builder<DescriptorType> doubleType() {
            this.type = AttributeType.DOUBLE;
            this.allowedValues = null;
            return this;
        }

        public Builder<DescriptorType> attribute(String name) {
            return this.parentBuilder.attribute(name);
        }

        public AnnotationConfig.Builder<DescriptorType> annotationMetadataCreator(AnnotationMetadataCreator<?, DescriptorType> annotationMetadataCreator) {
            return this.parentBuilder.annotationMetadataCreator(annotationMetadataCreator);
        }

        AnnotationAttributeConfig buildAnnotationAttributeConfig() {
            HashSet<String> _allowedValues = null;
            if (this.allowedValues != null && this.allowedValues.length != 0) {
                _allowedValues = new HashSet<String>(this.allowedValues.length);
                for (String v : this.allowedValues) {
                    _allowedValues.add(v);
                }
            }
            return new AnnotationAttributeConfig(this.name, this.isMultiple, this.defaultValue, this.type, _allowedValues);
        }

        public Configuration build() {
            return this.parentBuilder.build();
        }
    }

    public static enum AttributeType {
        IDENTIFIER,
        STRING,
        CHARACTER,
        BOOLEAN,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        ANNOTATION;

    }
}

