/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.config.AnnotationConfig;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.Rule;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public final class FieldDescriptor
extends AnnotatedDescriptorImpl
implements AnnotatedDescriptor {
    private static final String PACKED = "packed";
    private final int number;
    private final Rule rule;
    private final List<Option> options;
    private final String typeName;
    private final String defaultValue;
    private final Map<String, Object> optionByName = new HashMap<String, Object>();
    private final boolean isExtension;
    private Type type;
    private FileDescriptor fileDescriptor;
    private Descriptor messageType;
    private Descriptor containingMessage;
    private EnumDescriptor enumDescriptor;

    private FieldDescriptor(Builder builder) {
        super(builder.name, null, builder.documentation);
        this.number = builder.number;
        this.rule = builder.rule;
        this.options = Collections.unmodifiableList(builder.options);
        for (Option opt : this.options) {
            this.optionByName.put(opt.getName(), opt.getValue());
        }
        this.typeName = builder.typeName;
        this.defaultValue = builder.defaultValue;
        this.isExtension = builder.isExtension;
    }

    public int getNumber() {
        return this.number;
    }

    public Type getType() {
        return this.type;
    }

    void setType(Type type) {
        this.type = type;
    }

    public Descriptor getMessageType() {
        return this.messageType;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Object getOptionByName(String name) {
        return this.optionByName.get(name);
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public boolean isRequired() {
        return this.rule.equals((Object)Rule.REQUIRED);
    }

    public boolean isRepeated() {
        return this.rule.equals((Object)Rule.REPEATED);
    }

    public boolean isPacked() {
        return this.optionByName.containsKey(PACKED);
    }

    public Object getDefaultValue() {
        if (!this.hasDefaultValue()) {
            return null;
        }
        if (!this.getJavaType().isScalar()) {
            throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
        }
        return this.getJavaType().fromString(this.defaultValue);
    }

    public boolean isExtension() {
        return this.isExtension;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public JavaType getJavaType() {
        return this.getType().getJavaType();
    }

    public EnumDescriptor getEnumDescriptor() {
        return this.enumDescriptor;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public Descriptor getContainingMessage() {
        return this.containingMessage;
    }

    void setContainingMessage(Descriptor containingMessage) {
        this.containingMessage = containingMessage;
        this.fullName = containingMessage.getFullName().concat(".").concat(this.name);
    }

    void setMessageType(Descriptor descriptor) {
        this.messageType = descriptor;
        this.type = Type.MESSAGE;
    }

    void setEnumType(EnumDescriptor enumDescriptor) {
        this.enumDescriptor = enumDescriptor;
        this.type = Type.ENUM;
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    protected AnnotationConfig<FieldDescriptor> getAnnotationConfig(String annotationName) {
        return this.fileDescriptor.configuration.fieldAnnotations().get(annotationName);
    }

    public static class Builder {
        private String typeName;
        private int number;
        private String name;
        private Rule rule;
        private List<Option> options;
        private String defaultValue;
        private boolean isExtension;
        private String documentation;

        public Builder withNumber(int number) {
            this.number = number;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder withRule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withIsExtension(boolean isExtension) {
            this.isExtension = isExtension;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public FieldDescriptor build() {
            FieldDescriptor fieldDescriptor = new FieldDescriptor(this);
            try {
                Type fieldType = Type.valueOf(this.typeName.toUpperCase());
                fieldDescriptor.setType(fieldType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return fieldDescriptor;
        }
    }
}

