/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.protostream.AnnotationParserException;
import org.infinispan.protostream.config.AnnotationAttributeConfig;
import org.infinispan.protostream.config.AnnotationConfig;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.impl.parser.AnnotationParser;

public abstract class AnnotatedDescriptorImpl
implements AnnotatedDescriptor {
    protected final String name;
    protected String fullName;
    protected final String documentation;
    protected Map<String, AnnotationElement.Annotation> annotations = null;
    protected Map<String, Object> parsedAnnotations = null;

    protected AnnotatedDescriptorImpl(String name, String fullName, String documentation) {
        this.name = name;
        this.fullName = fullName;
        this.documentation = documentation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    private void processAnnotations() throws AnnotationParserException {
        if (this.annotations == null) {
            if (this.documentation != null) {
                AnnotationParser parser = new AnnotationParser(this.documentation);
                Map<String, AnnotationElement.Annotation> _annotations = parser.parse();
                LinkedHashMap<String, Object> _parsedAnnotations = new LinkedHashMap<String, Object>();
                for (AnnotationElement.Annotation annotation : _annotations.values()) {
                    AnnotationConfig<AnnotatedDescriptor> annotationConfig = this.getAnnotationConfig(annotation.getName());
                    if (annotationConfig == null) {
                        throw new AnnotationParserException("Unexpected annotation '" + annotation.getName() + "' on " + this.getFullName());
                    }
                    this.validateAttributes(annotation, annotationConfig);
                    if (annotationConfig.annotationMetadataCreator() == null) continue;
                    _parsedAnnotations.put(annotation.getName(), annotationConfig.annotationMetadataCreator().create(this, annotation));
                }
                this.annotations = _annotations;
                this.parsedAnnotations = _parsedAnnotations;
            } else {
                this.annotations = Collections.emptyMap();
                this.parsedAnnotations = Collections.emptyMap();
            }
        }
    }

    private void validateAttributes(AnnotationElement.Annotation annotation, AnnotationConfig<AnnotatedDescriptor> annotationConfig) {
        for (AnnotationElement.Attribute attribute : annotation.getAttributes().values()) {
            AnnotationAttributeConfig attributeConfig = annotationConfig.attributes().get(attribute.getName());
            if (attributeConfig == null) {
                throw new AnnotationParserException("Unexpected annotation attribute '" + attribute.getName() + "' in annotation '" + annotation.getName() + "' on " + this.getFullName());
            }
            switch (attributeConfig.type()) {
                case IDENTIFIER: {
                    if (!(attribute.getValue() instanceof AnnotationElement.Identifier)) {
                        throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be an identifier");
                    }
                    if (attributeConfig.allowedValues() == null || attributeConfig.allowedValues().contains(attribute.getValue().getValue())) break;
                    throw new AnnotationParserException("Annotation attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " should have one of the values : " + attributeConfig.allowedValues());
                }
                case STRING: {
                    if (!(attribute.getValue() instanceof AnnotationElement.Literal) || !(attribute.getValue().getValue() instanceof String)) {
                        throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a String");
                    }
                    if (attributeConfig.allowedValues() == null || attributeConfig.allowedValues().contains(attribute.getValue().getValue())) break;
                    throw new AnnotationParserException("Annotation attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " should have one of the values : " + attributeConfig.allowedValues());
                }
                case CHARACTER: {
                    if (attribute.getValue() instanceof AnnotationElement.Literal && attribute.getValue().getValue() instanceof Character) break;
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a char");
                }
                case BOOLEAN: {
                    if (attribute.getValue() instanceof AnnotationElement.Literal && attribute.getValue().getValue() instanceof Boolean) break;
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a boolean");
                }
                case INT: {
                    if (attribute.getValue() instanceof AnnotationElement.Literal && attribute.getValue().getValue() instanceof Integer) break;
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be an int");
                }
                case LONG: {
                    if (attribute.getValue() instanceof AnnotationElement.Literal && attribute.getValue().getValue() instanceof Long) break;
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a long");
                }
                case FLOAT: {
                    if (attribute.getValue() instanceof AnnotationElement.Literal && attribute.getValue().getValue() instanceof Float) break;
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a float");
                }
                case DOUBLE: {
                    if (attribute.getValue() instanceof AnnotationElement.Literal && attribute.getValue().getValue() instanceof Double) break;
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be a double");
                }
                case ANNOTATION: {
                    if (attribute.getValue() instanceof AnnotationElement.Annotation) break;
                    throw new AnnotationParserException("Value of attribute '" + attribute.getName() + "' of annotation '" + annotation.getName() + "' on " + this.getFullName() + " must be an annotation");
                }
            }
        }
        for (AnnotationAttributeConfig attributeConfig : annotationConfig.attributes().values()) {
            if (annotation.getAttributes().containsKey(attributeConfig.name()) || attributeConfig.defaultValue() == null) continue;
            AnnotationElement.Value value = attributeConfig.type() == AnnotationAttributeConfig.AttributeType.IDENTIFIER ? new AnnotationElement.Identifier(0L, (String)attributeConfig.defaultValue()) : new AnnotationElement.Literal(0L, attributeConfig.defaultValue());
            annotation.getAttributes().put(attributeConfig.name(), new AnnotationElement.Attribute(0L, attributeConfig.name(), value));
        }
    }

    protected abstract AnnotationConfig<? extends AnnotatedDescriptor> getAnnotationConfig(String var1);

    @Override
    public Map<String, AnnotationElement.Annotation> getAnnotations() throws AnnotationParserException {
        this.processAnnotations();
        return this.annotations;
    }

    @Override
    public <T> T getProcessedAnnotation(String annotationName) throws AnnotationParserException {
        this.processAnnotations();
        return (T)this.parsedAnnotations.get(annotationName);
    }
}

