/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.ProtoSchemaGenerator;
import org.infinispan.protostream.config.Configuration;
import protostream.org.apache.commons.cli.CommandLine;
import protostream.org.apache.commons.cli.GnuParser;
import protostream.org.apache.commons.cli.HelpFormatter;
import protostream.org.apache.commons.cli.Option;
import protostream.org.apache.commons.cli.Options;

public final class ProtoSchemaBuilder {
    public static boolean generateSchemaDebugComments = false;
    private String fileName;
    private String packageName;
    private final Set<Class<?>> classes = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String[] marshallers;
        Option f = new Option("f", "file", true, "output file name");
        Option p = new Option("p", "package", true, "Protobuf package name");
        p.setRequired(true);
        Option h = new Option("h", "help", false, "Print usage information");
        Option m = new Option("m", "marshaller", true, "Register custom marshaller class");
        Option s = new Option("s", "schema", true, "Register Protobuf schema");
        s.setArgs(2);
        s.setValueSeparator('=');
        Options options = new Options();
        options.addOption(f);
        options.addOption(p);
        options.addOption(h);
        options.addOption(m);
        options.addOption(s);
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java " + ProtoSchemaBuilder.class.getName(), "Arguments: ", options, "followed by an arbitrary list of class names to process");
            return;
        }
        String packageName = cmd.getOptionValue("package");
        Configuration config = new Configuration.Builder().build();
        SerializationContext ctx = ProtobufUtil.newSerializationContext(config);
        Properties schemas = cmd.getOptionProperties("schema");
        if (schemas != null) {
            for (String schema : schemas.stringPropertyNames()) {
                String file = schemas.getProperty(schema);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    ctx.registerProtoFiles(new FileDescriptorSource().addProtoFile(schema, in));
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
        if ((marshallers = cmd.getOptionValues("marshaller")) != null) {
            for (String marshaller : marshallers) {
                BaseMarshaller bm = (BaseMarshaller)Class.forName(marshaller).newInstance();
                ctx.registerMarshaller(bm);
            }
        }
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder().fileName("generated.proto").packageName(packageName);
        for (String className : cmd.getArgs()) {
            protoSchemaBuilder.addClass(Class.forName(className));
        }
        String schema = protoSchemaBuilder.build(ctx);
        if (cmd.hasOption("file")) {
            String file = cmd.getOptionValue("file");
            PrintStream out = new PrintStream(new FileOutputStream(file));
            try {
                out.println(schema);
            }
            finally {
                out.close();
            }
        } else {
            System.out.println(schema);
        }
    }

    public ProtoSchemaBuilder fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ProtoSchemaBuilder packageName(String packageName) {
        if (packageName.trim().isEmpty()) {
            throw new IllegalArgumentException("packageName cannot be empty");
        }
        this.packageName = packageName;
        return this;
    }

    public ProtoSchemaBuilder addClass(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    public String build(SerializationContext serializationContext) throws ProtoSchemaBuilderException, IOException {
        if (this.fileName == null) {
            throw new ProtoSchemaBuilderException("fileName cannot be null");
        }
        if (this.classes.isEmpty()) {
            throw new ProtoSchemaBuilderException("At least one class must be specified");
        }
        return new ProtoSchemaGenerator(serializationContext, this.fileName, this.packageName, this.classes).generateAndRegister();
    }
}

