/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.MessageMarshallerDelegate;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.WriteMessageContext;
import org.jboss.logging.Logger;

final class ProtoStreamWriterImpl
implements MessageMarshaller.ProtoStreamWriter {
    private static final Log log = Log.LogFactory.getLog(ProtoStreamWriterImpl.class);
    private final SerializationContextImpl ctx;
    private WriteMessageContext messageContext;

    public ProtoStreamWriterImpl(SerializationContextImpl ctx) {
        this.ctx = ctx;
    }

    WriteMessageContext pushContext(FieldDescriptor fd, MessageMarshallerDelegate<?> marshallerDelegate, RawProtoStreamWriter out) {
        this.messageContext = new WriteMessageContext(this.messageContext, fd == null ? null : fd.getName(), marshallerDelegate, out);
        return this.messageContext;
    }

    void popContext() {
        this.messageContext = (WriteMessageContext)this.messageContext.getParentContext();
    }

    @Override
    public void writeInt(String fieldName, Integer value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeInt(fieldName, (int)value);
    }

    @Override
    public void writeInt(String fieldName, int value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        switch (fd.getType()) {
            case INT32: {
                this.messageContext.out.writeInt32(fd.getNumber(), value);
                break;
            }
            case FIXED32: {
                this.messageContext.out.writeFixed32(fd.getNumber(), value);
                break;
            }
            case UINT32: {
                this.messageContext.out.writeUInt32(fd.getNumber(), value);
                break;
            }
            case SFIXED32: {
                this.messageContext.out.writeSFixed32(fd.getNumber(), value);
                break;
            }
            case SINT32: {
                this.messageContext.out.writeSInt32(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeLong(String fieldName, long value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        switch (fd.getType()) {
            case INT64: {
                this.messageContext.out.writeInt64(fd.getNumber(), value);
                break;
            }
            case UINT64: {
                this.messageContext.out.writeUInt64(fd.getNumber(), value);
                break;
            }
            case FIXED64: {
                this.messageContext.out.writeFixed64(fd.getNumber(), value);
                break;
            }
            case SFIXED64: {
                this.messageContext.out.writeSFixed64(fd.getNumber(), value);
                break;
            }
            case SINT64: {
                this.messageContext.out.writeSInt64(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeLong(String fieldName, Long value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeLong(fieldName, (long)value);
    }

    @Override
    public void writeDouble(String fieldName, double value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        if (fd.getType() != Type.DOUBLE) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.messageContext.out.writeDouble(fd.getNumber(), value);
    }

    @Override
    public void writeDouble(String fieldName, Double value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeDouble(fieldName, (double)value);
    }

    @Override
    public void writeFloat(String fieldName, float value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        if (fd.getType() != Type.FLOAT) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.messageContext.out.writeFloat(fd.getNumber(), value);
    }

    @Override
    public void writeFloat(String fieldName, Float value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeFloat(fieldName, value.floatValue());
    }

    @Override
    public void writeBoolean(String fieldName, boolean value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        if (fd.getType() != Type.BOOL) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fieldName);
        }
        this.messageContext.out.writeBool(fd.getNumber(), value);
    }

    @Override
    public void writeBoolean(String fieldName, Boolean value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeBoolean(fieldName, (boolean)value);
    }

    @Override
    public void writeString(String fieldName, String value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.checkFieldWrite(fd, false);
        if (fd.getType() != Type.STRING) {
            throw new IllegalArgumentException("Declared field type is not of type String : " + fieldName);
        }
        this.messageContext.out.writeString(fd.getNumber(), value);
    }

    @Override
    public void writeBytes(String fieldName, byte[] value) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.checkFieldWrite(fd, false);
        if (fd.getType() != Type.BYTES) {
            throw new IllegalArgumentException("Declared field type is not of type byte[] : " + fieldName);
        }
        this.messageContext.out.writeBytes(fd.getNumber(), value);
    }

    @Override
    public <E> void writeObject(String fieldName, E value, Class<? extends E> clazz) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.checkFieldWrite(fd, false);
        if (fd.getType() == Type.GROUP) {
            this.writeGroup(fd, value, clazz);
        } else if (fd.getType() == Type.MESSAGE) {
            this.writeMessage(fd, value, clazz);
        } else if (fd.getType() == Type.ENUM) {
            this.writeEnum(fd, (Enum)value);
        } else {
            throw new IllegalArgumentException("Declared field type is not a message or an enum : " + fieldName);
        }
    }

    private void writeMessage(FieldDescriptor fd, Object value, Class clazz) throws IOException {
        BaseMarshallerDelegate<Object> marshallerDelegate = this.ctx.getMarshallerDelegate(clazz);
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
        RawProtoStreamWriter out = RawProtoStreamWriterImpl.newInstance(baos);
        marshallerDelegate.marshall(fd, value, this, out);
        out.flush();
        this.messageContext.out.writeBytes(fd.getNumber(), baos.getByteBuffer());
    }

    private void writeGroup(FieldDescriptor fd, Object value, Class clazz) throws IOException {
        BaseMarshallerDelegate<Object> marshallerDelegate = this.ctx.getMarshallerDelegate(clazz);
        this.messageContext.out.writeTag(fd.getNumber(), 3);
        marshallerDelegate.marshall(fd, value, this, this.messageContext.out);
        this.messageContext.out.writeTag(fd.getNumber(), 4);
    }

    private <T extends Enum<T>> void writeEnum(FieldDescriptor fd, T value) throws IOException {
        BaseMarshallerDelegate<?> marshallerDelegate = this.ctx.getMarshallerDelegate(value.getClass());
        marshallerDelegate.marshall(fd, value, this, this.messageContext.out);
    }

    @Override
    public <E> void writeCollection(String fieldName, Collection<? super E> collection, Class<E> elementClass) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (collection == null) {
            return;
        }
        this.checkFieldWrite(fd, true);
        Type type = fd.getType();
        if (type == Type.GROUP) {
            for (E t : collection) {
                this.writeGroup(fd, t, elementClass);
            }
        } else if (type == Type.MESSAGE) {
            for (E t : collection) {
                this.writeMessage(fd, t, elementClass);
            }
        } else if (type == Type.ENUM) {
            for (E t : collection) {
                this.writeEnum(fd, (Enum)t);
            }
        } else {
            RawProtoStreamWriter out = this.messageContext.out;
            int fieldNumber = fd.getNumber();
            switch (type) {
                case DOUBLE: {
                    for (E value : collection) {
                        out.writeDouble(fieldNumber, (Double)value);
                    }
                    break;
                }
                case FLOAT: {
                    for (E value : collection) {
                        out.writeFloat(fieldNumber, ((Float)value).floatValue());
                    }
                    break;
                }
                case BOOL: {
                    for (E value : collection) {
                        out.writeBool(fieldNumber, (Boolean)value);
                    }
                    break;
                }
                case STRING: {
                    for (E value : collection) {
                        out.writeString(fieldNumber, (String)value);
                    }
                    break;
                }
                case BYTES: {
                    for (E value : collection) {
                        out.writeBytes(fieldNumber, (byte[])value);
                    }
                    break;
                }
                case INT64: {
                    for (E value : collection) {
                        out.writeInt64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case UINT64: {
                    for (E value : collection) {
                        out.writeUInt64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case FIXED64: {
                    for (E value : collection) {
                        out.writeFixed64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case SFIXED64: {
                    for (E value : collection) {
                        out.writeSFixed64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case SINT64: {
                    for (E value : collection) {
                        out.writeSInt64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case INT32: {
                    for (E value : collection) {
                        out.writeInt32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                case FIXED32: {
                    for (E value : collection) {
                        out.writeFixed32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                case UINT32: {
                    for (E value : collection) {
                        out.writeUInt32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                case SFIXED32: {
                    for (E value : collection) {
                        out.writeSFixed32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                case SINT32: {
                    for (E value : collection) {
                        out.writeSInt32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field type : " + (Object)((Object)type));
                }
            }
        }
    }

    @Override
    public <E> void writeArray(String fieldName, E[] array, Class<? extends E> elementClass) throws IOException {
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        if (array == null) {
            return;
        }
        this.checkFieldWrite(fd, true);
        Type type = fd.getType();
        if (type == Type.GROUP) {
            for (E t : array) {
                this.writeGroup(fd, t, elementClass);
            }
        } else if (type == Type.MESSAGE) {
            for (E t : array) {
                this.writeMessage(fd, t, elementClass);
            }
        } else if (type == Type.ENUM) {
            for (E t : array) {
                this.writeEnum(fd, (Enum)t);
            }
        } else {
            RawProtoStreamWriter out = this.messageContext.out;
            int fieldNumber = fd.getNumber();
            switch (type) {
                case DOUBLE: {
                    for (E value : array) {
                        out.writeDouble(fieldNumber, (Double)value);
                    }
                    break;
                }
                case FLOAT: {
                    for (E value : array) {
                        out.writeFloat(fieldNumber, ((Float)value).floatValue());
                    }
                    break;
                }
                case BOOL: {
                    for (E value : array) {
                        out.writeBool(fieldNumber, (Boolean)value);
                    }
                    break;
                }
                case STRING: {
                    for (E value : array) {
                        out.writeString(fieldNumber, (String)value);
                    }
                    break;
                }
                case BYTES: {
                    for (E value : array) {
                        out.writeBytes(fieldNumber, (byte[])value);
                    }
                    break;
                }
                case INT64: {
                    for (E value : array) {
                        out.writeInt64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case UINT64: {
                    for (E value : array) {
                        out.writeUInt64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case FIXED64: {
                    for (E value : array) {
                        out.writeFixed64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case SFIXED64: {
                    for (E value : array) {
                        out.writeSFixed64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case SINT64: {
                    for (E value : array) {
                        out.writeSInt64(fieldNumber, (Long)value);
                    }
                    break;
                }
                case INT32: {
                    for (E value : array) {
                        out.writeInt32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                case FIXED32: {
                    for (E value : array) {
                        out.writeFixed32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                case UINT32: {
                    for (E value : array) {
                        out.writeUInt32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                case SFIXED32: {
                    for (E value : array) {
                        out.writeSFixed32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                case SINT32: {
                    for (E value : array) {
                        out.writeSInt32(fieldNumber, (Integer)value);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field type : " + (Object)((Object)type));
                }
            }
        }
    }

    @Override
    public void writeDate(String fieldName, Date value) throws IOException {
        if (value != null) {
            this.writeLong(fieldName, value.getTime());
        }
    }

    private void checkFieldWrite(FieldDescriptor fd, boolean expectRepeated) {
        if (expectRepeated) {
            if (!fd.isRepeated()) {
                throw new IllegalArgumentException("This field is not repeated and cannot be written with the methods intended for collections or arrays: " + fd.getFullName());
            }
        } else if (fd.isRepeated()) {
            throw new IllegalArgumentException("A repeated field should be written with one of the methods intended for collections or arrays: " + fd.getFullName());
        }
        if (!this.messageContext.markField(fd.getNumber())) {
            throw new IllegalStateException("A field cannot be written twice : " + fd.getFullName());
        }
        if (this.ctx.getConfiguration().logOutOfSequenceWrites() && log.isEnabled(Logger.Level.WARN) && this.messageContext.getMaxSeenFieldNumber() > fd.getNumber()) {
            log.fieldWriteOutOfSequence(fd.getFullName());
        }
    }
}

