/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;

public final class WrappedMessageMarshaller
implements RawProtobufMarshaller<WrappedMessage> {
    public static final int WRAPPED_DOUBLE = 1;
    public static final int WRAPPED_FLOAT = 2;
    public static final int WRAPPED_INT64 = 3;
    public static final int WRAPPED_UINT64 = 4;
    public static final int WRAPPED_INT32 = 5;
    public static final int WRAPPED_FIXED64 = 6;
    public static final int WRAPPED_FIXED32 = 7;
    public static final int WRAPPED_BOOL = 8;
    public static final int WRAPPED_STRING = 9;
    public static final int WRAPPED_BYTES = 10;
    public static final int WRAPPED_UINT32 = 11;
    public static final int WRAPPED_SFIXED32 = 12;
    public static final int WRAPPED_SFIXED64 = 13;
    public static final int WRAPPED_SINT32 = 14;
    public static final int WRAPPED_SINT64 = 15;
    public static final int WRAPPED_DESCRIPTOR_FULL_NAME = 16;
    public static final int WRAPPED_MESSAGE_BYTES = 17;
    public static final int WRAPPED_ENUM = 18;
    public static final int WRAPPED_DESCRIPTOR_ID = 19;

    @Override
    public Class<? extends WrappedMessage> getJavaClass() {
        return WrappedMessage.class;
    }

    @Override
    public String getTypeName() {
        return "org.infinispan.protostream.WrappedMessage";
    }

    @Override
    public WrappedMessage readFrom(SerializationContext ctx, RawProtoStreamReader in) throws IOException {
        Object o = WrappedMessageMarshaller.readWrappedMessage(ctx, in);
        return new WrappedMessage(o);
    }

    @Override
    public void writeTo(SerializationContext ctx, RawProtoStreamWriter out, WrappedMessage wrappedMessage) throws IOException {
        WrappedMessageMarshaller.writeWrappedMessage(ctx, out, wrappedMessage.getValue());
    }

    public static void writeWrappedMessage(SerializationContext ctx, RawProtoStreamWriter out, Object t) throws IOException {
        if (t == null) {
            return;
        }
        if (t instanceof String) {
            out.writeString(9, (String)t);
        } else if (t instanceof Long) {
            out.writeInt64(3, (Long)t);
        } else if (t instanceof Integer) {
            out.writeInt32(5, (Integer)t);
        } else if (t instanceof Double) {
            out.writeDouble(1, (Double)t);
        } else if (t instanceof Float) {
            out.writeFloat(2, ((Float)t).floatValue());
        } else if (t instanceof Boolean) {
            out.writeBool(8, (Boolean)t);
        } else if (t instanceof byte[]) {
            byte[] bytes = (byte[])t;
            out.writeBytes(10, bytes);
        } else if (t instanceof Enum) {
            EnumMarshaller enumMarshaller = (EnumMarshaller)ctx.getMarshaller(t.getClass());
            int encodedEnum = enumMarshaller.encode((Enum)t);
            Integer typeId = ctx.getTypeIdByName(enumMarshaller.getTypeName());
            if (typeId == null) {
                out.writeString(16, enumMarshaller.getTypeName());
            } else {
                out.writeInt32(19, typeId);
            }
            out.writeEnum(18, encodedEnum);
        } else {
            BaseMarshallerDelegate<?> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t.getClass());
            ByteArrayOutputStreamEx buffer = new ByteArrayOutputStreamEx();
            RawProtoStreamWriter nestedOut = RawProtoStreamWriterImpl.newInstance(buffer);
            marshallerDelegate.marshall(null, t, null, nestedOut);
            nestedOut.flush();
            Integer typeId = ctx.getTypeIdByName(marshallerDelegate.getMarshaller().getTypeName());
            if (typeId == null) {
                out.writeString(16, marshallerDelegate.getMarshaller().getTypeName());
            } else {
                out.writeInt32(19, typeId);
            }
            out.writeBytes(17, buffer.getByteBuffer());
        }
        out.flush();
    }

    public static Object readWrappedMessage(SerializationContext ctx, RawProtoStreamReader in) throws IOException {
        int tag;
        String descriptorFullName = null;
        Integer typeId = null;
        int enumValue = -1;
        byte[] messageBytes = null;
        Object value = null;
        int readTags = 0;
        block21: while ((tag = in.readTag()) != 0) {
            ++readTags;
            switch (tag) {
                case 130: {
                    descriptorFullName = in.readString();
                    continue block21;
                }
                case 152: {
                    typeId = in.readInt32();
                    continue block21;
                }
                case 144: {
                    enumValue = in.readEnum();
                    continue block21;
                }
                case 138: {
                    messageBytes = in.readByteArray();
                    continue block21;
                }
                case 74: {
                    value = in.readString();
                    continue block21;
                }
                case 82: {
                    value = in.readByteArray();
                    continue block21;
                }
                case 64: {
                    value = in.readBool();
                    continue block21;
                }
                case 9: {
                    value = in.readDouble();
                    continue block21;
                }
                case 21: {
                    value = Float.valueOf(in.readFloat());
                    continue block21;
                }
                case 61: {
                    value = in.readFixed32();
                    continue block21;
                }
                case 101: {
                    value = in.readSFixed32();
                    continue block21;
                }
                case 49: {
                    value = in.readFixed64();
                    continue block21;
                }
                case 105: {
                    value = in.readSFixed64();
                    continue block21;
                }
                case 24: {
                    value = in.readInt64();
                    continue block21;
                }
                case 32: {
                    value = in.readUInt64();
                    continue block21;
                }
                case 120: {
                    value = in.readSInt64();
                    continue block21;
                }
                case 40: {
                    value = in.readInt32();
                    continue block21;
                }
                case 88: {
                    value = in.readUInt32();
                    continue block21;
                }
                case 112: {
                    value = in.readSInt32();
                    continue block21;
                }
            }
            throw new IllegalStateException("Unexpected tag : " + tag);
        }
        if (value == null && descriptorFullName == null && typeId == null && messageBytes == null) {
            return null;
        }
        if (value != null) {
            if (readTags != 1) {
                throw new IOException("Invalid message encoding.");
            }
            return value;
        }
        if (descriptorFullName == null && typeId == null || descriptorFullName != null && typeId != null || readTags != 2) {
            throw new IOException("Invalid message encoding.");
        }
        if (typeId != null) {
            descriptorFullName = ctx.getTypeNameById(typeId);
        }
        BaseMarshallerDelegate marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(descriptorFullName);
        if (messageBytes != null) {
            RawProtoStreamReader nestedInput = RawProtoStreamReaderImpl.newInstance(messageBytes);
            return marshallerDelegate.unmarshall(null, null, nestedInput);
        }
        EnumMarshaller marshaller = (EnumMarshaller)marshallerDelegate.getMarshaller();
        return marshaller.decode(enumValue);
    }
}

