/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.config.AnnotationConfig;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public final class Descriptor
extends AnnotatedDescriptorImpl
implements GenericDescriptor {
    private Integer typeId;
    private final List<Option> options;
    private final List<FieldDescriptor> fields;
    private final List<Descriptor> nestedTypes;
    private final List<EnumDescriptor> enumTypes;
    private final Map<Integer, FieldDescriptor> fieldsByNumber = new HashMap<Integer, FieldDescriptor>();
    private final Map<String, FieldDescriptor> fieldsByName = new HashMap<String, FieldDescriptor>();
    private FileDescriptor fileDescriptor;
    private Descriptor containingType;

    private Descriptor(Builder builder) {
        super(builder.name, builder.fullName, builder.documentation);
        this.options = Collections.unmodifiableList(builder.options);
        this.fields = Collections.unmodifiableList(builder.fields);
        for (FieldDescriptor fieldDescriptor : this.fields) {
            this.fieldsByName.put(fieldDescriptor.getName(), fieldDescriptor);
            this.fieldsByNumber.put(fieldDescriptor.getNumber(), fieldDescriptor);
            fieldDescriptor.setContainingMessage(this);
        }
        this.nestedTypes = Collections.unmodifiableList(builder.nestedTypes);
        this.enumTypes = Collections.unmodifiableList(builder.enumTypes);
        for (Descriptor descriptor : this.nestedTypes) {
            descriptor.setContainingType(this);
        }
        for (EnumDescriptor enumDescriptor : this.enumTypes) {
            enumDescriptor.setContainingType(this);
        }
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public List<Descriptor> getNestedTypes() {
        return this.nestedTypes;
    }

    public List<EnumDescriptor> getEnumTypes() {
        return this.enumTypes;
    }

    public FieldDescriptor findFieldByNumber(int number) {
        return this.fieldsByNumber.get(number);
    }

    public FieldDescriptor findFieldByName(String name) {
        return this.fieldsByName.get(name);
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
        for (FieldDescriptor fieldDescriptor : this.fields) {
            fieldDescriptor.setFileDescriptor(fileDescriptor);
        }
        for (Descriptor descriptor : this.nestedTypes) {
            descriptor.setFileDescriptor(fileDescriptor);
        }
        for (EnumDescriptor enumDescriptor : this.enumTypes) {
            enumDescriptor.setFileDescriptor(fileDescriptor);
        }
        this.typeId = (Integer)this.getProcessedAnnotation("TypeId");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return this.fullName.equals(that.fullName);
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public Integer getTypeId() {
        return this.typeId;
    }

    @Override
    public Descriptor getContainingType() {
        return this.containingType;
    }

    private void setContainingType(Descriptor containingType) {
        this.containingType = containingType;
        for (Descriptor descriptor : this.nestedTypes) {
            descriptor.setContainingType(this);
        }
        for (EnumDescriptor enumDescriptor : this.enumTypes) {
            enumDescriptor.setContainingType(this);
        }
    }

    protected AnnotationConfig<Descriptor> getAnnotationConfig(String annotationName) {
        return this.fileDescriptor.configuration.messageAnnotations().get(annotationName);
    }

    public static class Builder {
        private String name;
        private String fullName;
        private List<Option> options;
        private List<FieldDescriptor> fields;
        private List<Descriptor> nestedTypes = new LinkedList<Descriptor>();
        private List<EnumDescriptor> enumTypes;
        private String documentation;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withFields(List<FieldDescriptor> fields) {
            this.fields = fields;
            return this;
        }

        public Builder withNestedTypes(List<Descriptor> nestedTypes) {
            this.nestedTypes = nestedTypes;
            return this;
        }

        public Builder withEnumTypes(List<EnumDescriptor> enumTypes) {
            this.enumTypes = enumTypes;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Descriptor build() {
            return new Descriptor(this);
        }
    }
}

