/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.ExtendDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.Type;

public final class FileDescriptor {
    private final String name;
    private final String packageName;
    private final String fullName;
    private final List<FileDescriptor> dependencies;
    private final List<Option> options;
    private final List<Descriptor> messageTypes;
    private final List<FieldDescriptor> extensions;
    private final List<EnumDescriptor> enumTypes;
    private final List<ExtendDescriptor> extendTypes;
    private final Map<String, ExtendDescriptor> extendDescriptors = new HashMap<String, ExtendDescriptor>();
    private final Map<String, Object> typeRegistry = new HashMap<String, Object>();

    private FileDescriptor(Builder builder) {
        this.name = builder.name;
        this.packageName = builder.packageName;
        this.dependencies = builder.dependencies;
        this.options = Collections.unmodifiableList(builder.options);
        this.enumTypes = Collections.unmodifiableList(builder.enumTypes);
        this.messageTypes = Collections.unmodifiableList(builder.messageTypes);
        this.extensions = builder.extensions;
        this.extendTypes = Collections.unmodifiableList(builder.extendDescriptors);
        this.fullName = this.getScopedName(this.name);
        for (FileDescriptor dep : this.dependencies) {
            this.typeRegistry.putAll(dep.typeRegistry);
        }
        this.collectTypes();
        this.wireInternalReferences();
    }

    private void collectTypes() {
        for (Descriptor desc : this.messageTypes) {
            this.collectDescriptors(desc);
        }
        for (EnumDescriptor enumDesc : this.enumTypes) {
            this.collectEnumDescriptors(enumDesc);
        }
        for (ExtendDescriptor extendDescriptor : this.extendTypes) {
            this.collectExtensions(extendDescriptor);
        }
    }

    private void collectDescriptors(Descriptor descriptor) {
        this.typeRegistry.put(descriptor.getFullName(), descriptor);
        for (EnumDescriptor enumDescriptor : descriptor.getEnumTypes()) {
            enumDescriptor.setFileDescriptor(this);
            this.typeRegistry.put(enumDescriptor.getFullName(), enumDescriptor);
        }
        for (Descriptor nested : descriptor.getNestedTypes()) {
            this.collectDescriptors(nested);
        }
    }

    private void collectEnumDescriptors(EnumDescriptor enumDesc) {
        this.typeRegistry.put(enumDesc.getFullName(), enumDesc);
    }

    private void collectExtensions(ExtendDescriptor extendDescriptor) {
        this.extendDescriptors.put(extendDescriptor.getFullName(), extendDescriptor);
    }

    private void wireDescriptor(Descriptor descriptor) {
        descriptor.setFileDescriptor(this);
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            fieldDescriptor.setContainingMessage(descriptor);
            fieldDescriptor.setFileDescriptor(this);
            if (fieldDescriptor.getType() != null) continue;
            Object res = this.searchType(fieldDescriptor.getTypeName(), descriptor);
            if (res instanceof EnumDescriptor) {
                fieldDescriptor.setType(Type.ENUM);
                fieldDescriptor.setEnumDescriptor((EnumDescriptor)res);
                continue;
            }
            if (res instanceof Descriptor) {
                fieldDescriptor.setType(Type.MESSAGE);
                fieldDescriptor.setMessageType((Descriptor)res);
                continue;
            }
            throw new DescriptorParserException("Field type " + fieldDescriptor.getTypeName() + " not found");
        }
        for (Descriptor nested : descriptor.getNestedTypes()) {
            this.wireDescriptor(nested);
        }
    }

    private void wireInternalReferences() {
        for (Descriptor descriptor : this.messageTypes) {
            this.wireDescriptor(descriptor);
            for (Descriptor nested : descriptor.getNestedTypes()) {
                this.wireDescriptor(nested);
            }
        }
        for (EnumDescriptor enumDescriptor : this.enumTypes) {
            enumDescriptor.setFileDescriptor(this);
        }
        for (ExtendDescriptor extendDescriptor : this.extendTypes) {
            extendDescriptor.setFileDescriptor(this);
            Object res = this.searchType(extendDescriptor.getName(), null);
            if (res == null) {
                throw new DescriptorParserException("Extension error: type " + extendDescriptor.getName() + " not found");
            }
            extendDescriptor.setExtendedMessage((Descriptor)res);
        }
    }

    private String getScopedName(String name) {
        if (this.packageName == null) {
            return name;
        }
        return this.packageName.concat(".").concat(name);
    }

    private Object searchType(String name, Descriptor scope) {
        Object fullyQualified = this.typeRegistry.get(this.getScopedName(name));
        if (fullyQualified != null) {
            return fullyQualified;
        }
        Object relativeName = this.typeRegistry.get(name);
        if (relativeName != null) {
            return relativeName;
        }
        String scoped = scope.getFullName();
        String searchScope = scoped.concat(".").concat(name);
        Object o = this.typeRegistry.get(searchScope);
        if (o != null) {
            return o;
        }
        for (Descriptor containingType = scope.getContainingType(); containingType != null; containingType = containingType.getContainingType()) {
            Object res = this.searchType(name, containingType);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        return this.packageName;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<EnumDescriptor> getEnumTypes() {
        return this.enumTypes;
    }

    public List<Descriptor> getMessageTypes() {
        return this.messageTypes;
    }

    public List<ExtendDescriptor> getExtensionsTypes() {
        return this.extendTypes;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static final class Builder {
        String name;
        String packageName;
        List<FileDescriptor> dependencies = new ArrayList<FileDescriptor>();
        List<FieldDescriptor> extensions;
        List<Option> options;
        List<EnumDescriptor> enumTypes;
        List<Descriptor> messageTypes;
        List<ExtendDescriptor> extendDescriptors;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder withDependencies(List<FileDescriptor> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public Builder withExtendDescriptors(List<ExtendDescriptor> extendDescriptors) {
            this.extendDescriptors = extendDescriptors;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withEnumTypes(List<EnumDescriptor> enumTypes) {
            this.enumTypes = enumTypes;
            return this;
        }

        public Builder withMessageTypes(List<Descriptor> messageTypes) {
            this.messageTypes = messageTypes;
            return this;
        }

        public FileDescriptor build() {
            return new FileDescriptor(this);
        }
    }
}

