/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser.mappers;

import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.MessageType;
import com.squareup.protoparser.ProtoFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.parser.mappers.Mapper;
import org.infinispan.protostream.impl.parser.mappers.Mappers;

public class ProtofileMapper
implements Mapper<ProtoFile, FileDescriptor> {
    private final Map<String, ProtoFile> protoFileMap;
    private final Set<String> processedFile = new HashSet<String>();

    public ProtofileMapper(Map<String, ProtoFile> protoFileMap) {
        this.protoFileMap = protoFileMap;
    }

    @Override
    public FileDescriptor map(ProtoFile protoFile) {
        List options = protoFile.getOptions();
        List types = protoFile.getTypes();
        List<MessageType> messageTypes = Mappers.filter(types, MessageType.class);
        List<EnumType> enumTypes = Mappers.filter(types, EnumType.class);
        List extendDeclarations = protoFile.getExtendDeclarations();
        List dependencies = protoFile.getDependencies();
        ArrayList<FileDescriptor> protoFiles = new ArrayList<FileDescriptor>(dependencies.size());
        for (String dependency : dependencies) {
            FileDescriptor fd = this.mapInternal(protoFile.getFileName(), dependency, this.processedFile);
            protoFiles.add(fd);
        }
        return new FileDescriptor.Builder().withName(protoFile.getFileName()).withPackageName(protoFile.getPackageName()).withMessageTypes(Mappers.MESSAGE_LIST_MAPPER.map(messageTypes)).withEnumTypes(Mappers.ENUM_LIST_MAPPER.map(enumTypes)).withExtendDescriptors(Mappers.EXTEND_LIST_MAPPER.map(extendDeclarations)).withOptions(Mappers.OPTION_LIST_MAPPER.map(options)).withDependencies(protoFiles).build();
    }

    private FileDescriptor mapInternal(String fileName, String dependency, Set<String> processedFile) {
        ProtoFile pf = this.protoFileMap.get(dependency);
        if (pf == null) {
            throw new DescriptorParserException("Import '" + dependency + "' not found");
        }
        if (processedFile.contains(dependency)) {
            throw new DescriptorParserException("Possible cyclic import detected at " + fileName + ", import " + dependency);
        }
        processedFile.add(dependency);
        return this.map(this.protoFileMap.get(dependency));
    }
}

