/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Latitude;
import org.hibernate.search.annotations.Longitude;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.Spatials;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.DefaultStringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.impl.BridgeFactory;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.AnnotationProcessingHelper;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.MetadataProvider;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AnnotationMetadataProvider
implements MetadataProvider {
    private static final Log log = LoggerFactory.make();
    private static final StringBridge NULL_EMBEDDED_STRING_BRIDGE = DefaultStringBridge.INSTANCE;
    private static final String UNKNOWN_MAPPED_BY_ROLE = "";
    private static final String EMPTY_PREFIX = "";
    private final ReflectionManager reflectionManager;
    private final ConfigContext configContext;
    private final BridgeFactory bridgeFactory;

    public AnnotationMetadataProvider(ReflectionManager reflectionManager, ConfigContext configContext) {
        this.reflectionManager = reflectionManager;
        this.configContext = configContext;
        this.bridgeFactory = new BridgeFactory(configContext.getServiceManager());
    }

    @Override
    public TypeMetadata getTypeMetadataFor(Class<?> clazz) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        TypeMetadata.Builder typeMetadataBuilder = new TypeMetadata.Builder(clazz, this.configContext).boost(this.getBoost(xClass)).boostStrategy(AnnotationProcessingHelper.getDynamicBoost((XAnnotatedElement)xClass)).analyzer(this.configContext.getDefaultAnalyzer());
        ParseContext parseContext = new ParseContext();
        parseContext.processingClass(xClass);
        parseContext.setCurrentClass(xClass);
        this.initializeClass(typeMetadataBuilder, true, "", parseContext, this.configContext, false, null);
        return typeMetadataBuilder.build();
    }

    @Override
    public boolean containsSearchMetadata(Class<?> clazz) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        return ReflectionHelper.containsSearchAnnotations(xClass);
    }

    private void checkDocumentId(XProperty member, TypeMetadata.Builder typeMetadataBuilder, boolean isRoot, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        Annotation idAnnotation = this.getIdAnnotation(member, typeMetadataBuilder, configContext);
        NumericField numericFieldAnn = (NumericField)member.getAnnotation(NumericField.class);
        if (idAnnotation != null) {
            String attributeName = this.getIdAttributeName(member, idAnnotation);
            if (pathsContext != null) {
                pathsContext.markEncounteredPath(prefix + attributeName);
            }
            if (isRoot) {
                FieldBridge idBridge;
                if (parseContext.isExplicitDocumentId()) {
                    if (idAnnotation instanceof DocumentId) {
                        throw log.duplicateDocumentIdFound(typeMetadataBuilder.getIndexedType().getName());
                    }
                    return;
                }
                if (idAnnotation instanceof DocumentId) {
                    parseContext.setExplicitDocumentId(true);
                }
                if (!((idBridge = this.bridgeFactory.guessType(null, numericFieldAnn, (XMember)member, this.reflectionManager, configContext.getServiceManager())) instanceof TwoWayFieldBridge)) {
                    throw new SearchException("Bridge for document id does not implement TwoWayFieldBridge: " + member.getName());
                }
                Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
                DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(prefix + attributeName, Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, termVector).id().boost(AnnotationProcessingHelper.getBoost(member, null)).fieldBridge(idBridge).build();
                PropertyMetadata idPropertyMetadata = new PropertyMetadata.Builder(member).addDocumentField(fieldMetadata).build();
                typeMetadataBuilder.idProperty(idPropertyMetadata);
            } else {
                String fieldName = prefix + attributeName;
                Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.YES);
                Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
                FieldBridge fieldBridge = this.bridgeFactory.guessType(null, null, (XMember)member, this.reflectionManager, configContext.getServiceManager());
                DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(fieldName, Store.YES, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, null)).fieldBridge(fieldBridge).idInEmbedded().build();
                PropertyMetadata propertyMetadata = new PropertyMetadata.Builder(member).addDocumentField(fieldMetadata).dynamicBoostStrategy(AnnotationProcessingHelper.getDynamicBoost((XAnnotatedElement)member)).build();
                typeMetadataBuilder.addProperty(propertyMetadata);
                Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((org.hibernate.search.annotations.Analyzer)member.getAnnotation(org.hibernate.search.annotations.Analyzer.class), configContext);
                if (analyzer == null) {
                    analyzer = typeMetadataBuilder.getAnalyzer();
                }
                if (analyzer == null) {
                    throw new AssertionFailure("Analyzer should not be undefined");
                }
                typeMetadataBuilder.addToScopedAnalyzer(fieldName, analyzer, index);
            }
        }
    }

    private Annotation getIdAnnotation(XProperty member, TypeMetadata.Builder typeMetadataBuilder, ConfigContext context) {
        Annotation idAnnotation = null;
        DocumentId documentIdAnnotation = (DocumentId)member.getAnnotation(DocumentId.class);
        if (documentIdAnnotation != null) {
            idAnnotation = documentIdAnnotation;
        }
        if (context.isJpaPresent()) {
            Annotation jpaId;
            try {
                Class jpaIdClass = ClassLoaderHelper.classForName("javax.persistence.Id", this.configContext.getServiceManager());
                jpaId = member.getAnnotation(jpaIdClass);
            }
            catch (ClassLoadingException e) {
                throw new SearchException("Unable to load @Id.class even though it should be present ?!");
            }
            if (jpaId != null) {
                typeMetadataBuilder.jpaProperty(member);
                if (documentIdAnnotation == null) {
                    log.debug("Found JPA id and using it as document id");
                    idAnnotation = jpaId;
                }
            }
        }
        return idAnnotation;
    }

    private void initializeProvidedIdMetadata(ProvidedId providedId, XClass clazz, TypeMetadata.Builder typeMetadataBuilder) {
        String providedIdFieldName;
        TwoWayFieldBridge providedIdFieldBridge;
        if (providedId != null) {
            providedIdFieldBridge = this.bridgeFactory.extractTwoWayType(providedId.bridge(), clazz, this.reflectionManager);
            providedIdFieldName = providedId.name();
        } else {
            providedIdFieldBridge = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.StringBridge.INSTANCE);
            providedIdFieldName = "providedId";
        }
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(providedIdFieldName, Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO).fieldBridge(providedIdFieldBridge).boost(Float.valueOf(1.0f)).build();
        PropertyMetadata propertyMetadata = new PropertyMetadata.Builder(null).addDocumentField(fieldMetadata).build();
        typeMetadataBuilder.idProperty(propertyMetadata);
    }

    private String getIdAttributeName(XProperty member, Annotation idAnnotation) {
        String name = null;
        try {
            Method m = idAnnotation.getClass().getMethod("name", new Class[0]);
            name = (String)m.invoke((Object)idAnnotation, new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ReflectionHelper.getAttributeName((XMember)member, name);
    }

    private float getBoost(XClass element) {
        float boost = 1.0f;
        if (element == null) {
            return boost;
        }
        Boost boostAnnotation = (Boost)element.getAnnotation(Boost.class);
        if (boostAnnotation != null) {
            boost = boostAnnotation.value();
        }
        return boost;
    }

    private void initializeClass(TypeMetadata.Builder typeMetadataBuilder, boolean isRoot, String prefix, ParseContext parseContext, ConfigContext configContext, boolean disableOptimizationsArg, PathsContext pathsContext) {
        List<XClass> hierarchy = ReflectionHelper.createXClassHierarchy(parseContext.getCurrentClass());
        ProvidedId explicitProvidedIdAnnotation = null;
        XClass providedIdHostingClass = null;
        for (XClass currentClass : hierarchy) {
            if (currentClass.getAnnotation(ProvidedId.class) != null) {
                explicitProvidedIdAnnotation = (ProvidedId)currentClass.getAnnotation(ProvidedId.class);
                providedIdHostingClass = currentClass;
            }
            parseContext.setCurrentClass(currentClass);
            this.initializeClassLevelAnnotations(typeMetadataBuilder, prefix, configContext, parseContext);
            this.initializeClassBridgeInstances(typeMetadataBuilder, prefix, configContext, currentClass);
        }
        boolean isProvidedId = false;
        if (explicitProvidedIdAnnotation != null || configContext.isProvidedIdImplicit()) {
            this.initializeProvidedIdMetadata(explicitProvidedIdAnnotation, providedIdHostingClass, typeMetadataBuilder);
            isProvidedId = true;
        }
        boolean disableOptimizations = disableOptimizationsArg || !this.stateInspectionOptimizationsEnabled(typeMetadataBuilder);
        for (XClass currentClass : hierarchy) {
            parseContext.setCurrentClass(currentClass);
            List methods = currentClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMemberLevelAnnotations(prefix, method, typeMetadataBuilder, disableOptimizations, isRoot, isProvidedId, configContext, pathsContext, parseContext);
            }
            List fields = currentClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMemberLevelAnnotations(prefix, field, typeMetadataBuilder, disableOptimizations, isRoot, isProvidedId, configContext, pathsContext, parseContext);
            }
            for (String unqualifiedCollectionRole : parseContext.getCollectedUnqualifiedCollectionRoles()) {
                typeMetadataBuilder.addCollectionRole(StringHelper.qualify(parseContext.getCurrentClass().getName(), unqualifiedCollectionRole));
            }
        }
    }

    private void initializeClassLevelAnnotations(TypeMetadata.Builder typeMetadataBuilder, String prefix, ConfigContext configContext, ParseContext parseContext) {
        Spatials spatialsAnnotation;
        Spatial spatialAnnotation;
        ClassBridge classBridgeAnnotation;
        XClass clazz = parseContext.getCurrentClass();
        Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((org.hibernate.search.annotations.Analyzer)clazz.getAnnotation(org.hibernate.search.annotations.Analyzer.class), configContext);
        if (analyzer != null) {
            typeMetadataBuilder.analyzer(analyzer);
        }
        this.checkForAnalyzerDefs((XAnnotatedElement)clazz, configContext);
        ClassBridges classBridgesAnnotation = (ClassBridges)clazz.getAnnotation(ClassBridges.class);
        if (classBridgesAnnotation != null) {
            ClassBridge[] classBridges;
            for (ClassBridge cb : classBridges = classBridgesAnnotation.value()) {
                this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, cb, clazz, configContext);
            }
        }
        if ((classBridgeAnnotation = (ClassBridge)clazz.getAnnotation(ClassBridge.class)) != null) {
            this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, classBridgeAnnotation, clazz, configContext);
        }
        if ((spatialAnnotation = (Spatial)clazz.getAnnotation(Spatial.class)) != null) {
            this.bindSpatialAnnotation(spatialAnnotation, prefix, typeMetadataBuilder, parseContext);
        }
        if ((spatialsAnnotation = (Spatials)clazz.getAnnotation(Spatials.class)) != null) {
            Spatial[] spatials;
            for (Spatial innerSpatialAnnotation : spatials = spatialsAnnotation.value()) {
                this.bindSpatialAnnotation(innerSpatialAnnotation, prefix, typeMetadataBuilder, parseContext);
            }
        }
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)clazz, typeMetadataBuilder, configContext);
    }

    private void initializeClassBridgeInstances(TypeMetadata.Builder typeMetadataBuilder, String prefix, ConfigContext configContext, XClass clazz) {
        Map<FieldBridge, ClassBridge> classBridgeInstances = configContext.getClassBridgeInstances(this.reflectionManager.toClass(clazz));
        for (Map.Entry<FieldBridge, ClassBridge> classBridge : classBridgeInstances.entrySet()) {
            FieldBridge instance = classBridge.getKey();
            ClassBridge configuration = classBridge.getValue();
            this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, configuration, instance, configContext);
        }
    }

    private void bindClassBridgeAnnotation(String prefix, TypeMetadata.Builder typeMetadataBuilder, ClassBridge classBridgeAnnotation, XClass clazz, ConfigContext configContext) {
        FieldBridge fieldBridge = this.bridgeFactory.extractType(classBridgeAnnotation, this.reflectionManager.toClass(clazz));
        this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, classBridgeAnnotation, fieldBridge, configContext);
    }

    private void bindClassBridgeAnnotation(String prefix, TypeMetadata.Builder typeMetadataBuilder, ClassBridge classBridgeAnnotation, FieldBridge fieldBridge, ConfigContext configContext) {
        this.bridgeFactory.injectParameters(classBridgeAnnotation, fieldBridge);
        String fieldName = prefix + classBridgeAnnotation.name();
        Store store = classBridgeAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(classBridgeAnnotation.index(), classBridgeAnnotation.analyze(), classBridgeAnnotation.norms());
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(classBridgeAnnotation.termVector());
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(fieldName, store, index, termVector).boost(Float.valueOf(classBridgeAnnotation.boost().value())).fieldBridge(fieldBridge).build();
        typeMetadataBuilder.addClassBridgeField(fieldMetadata);
        Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer(classBridgeAnnotation.analyzer(), configContext);
        typeMetadataBuilder.addToScopedAnalyzer(fieldName, analyzer, index);
    }

    private void bindSpatialAnnotation(Spatial spatialAnnotation, String prefix, XProperty member, TypeMetadata.Builder typeMetadataBuilder, ParseContext parseContext) {
        if (parseContext.isSpatialNameUsed(spatialAnnotation.name())) {
            throw log.cannotHaveTwoSpatialsWithDefaultOrSameName(member.getType().getName());
        }
        parseContext.markSpatialNameAsUsed(spatialAnnotation.name());
        String fieldName = prefix + ReflectionHelper.getAttributeName((XMember)member, spatialAnnotation.name());
        Store store = spatialAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.NO);
        Field.TermVector termVector = Field.TermVector.NO;
        FieldBridge fieldBridge = this.bridgeFactory.guessType(null, null, (XMember)member, this.reflectionManager, this.configContext.getServiceManager());
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(fieldName, store, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, spatialAnnotation)).fieldBridge(fieldBridge).build();
        PropertyMetadata propertyMetadata = new PropertyMetadata.Builder(member).addDocumentField(fieldMetadata).build();
        typeMetadataBuilder.addProperty(propertyMetadata);
        if (member.isCollection()) {
            parseContext.collectUnqualifiedCollectionRole(member.getName());
        }
    }

    private void bindSpatialAnnotation(Spatial spatialAnnotation, String prefix, TypeMetadata.Builder typeMetadataBuilder, ParseContext parseContext) {
        String fieldName = !spatialAnnotation.name().isEmpty() ? prefix + spatialAnnotation.name() : "_hibernate_default_coordinates";
        if (parseContext.isSpatialNameUsed(spatialAnnotation.name())) {
            throw log.cannotHaveTwoSpatialsWithDefaultOrSameName(parseContext.getCurrentClass().getName());
        }
        parseContext.markSpatialNameAsUsed(spatialAnnotation.name());
        Store store = spatialAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.NO);
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
        FieldBridge spatialBridge = this.determineSpatialFieldBridge(spatialAnnotation, parseContext);
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(fieldName, store, index, termVector).boost(Float.valueOf(spatialAnnotation.boost().value())).fieldBridge(spatialBridge).build();
        typeMetadataBuilder.addClassBridgeField(fieldMetadata);
        Analyzer analyzer = typeMetadataBuilder.getAnalyzer();
        if (analyzer == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
    }

    private FieldBridge determineSpatialFieldBridge(Spatial spatialAnnotation, ParseContext parseContext) {
        FieldBridge spatialBridge;
        XClass clazz = parseContext.getCurrentClass();
        if (this.reflectionManager.toXClass(Coordinates.class).isAssignableFrom(clazz)) {
            spatialBridge = this.bridgeFactory.buildSpatialBridge(spatialAnnotation, clazz, null, null);
        } else {
            String latitudeField = null;
            String longitudeField = null;
            List fieldList = clazz.getDeclaredProperties("field");
            for (XProperty property : fieldList) {
                if (property.isAnnotationPresent(Latitude.class) && ((Latitude)property.getAnnotation(Latitude.class)).of().equals(spatialAnnotation.name())) {
                    if (latitudeField != null) {
                        throw log.ambiguousLatitudeDefinition(clazz.getName(), latitudeField, property.getName());
                    }
                    latitudeField = property.getName();
                }
                if (!property.isAnnotationPresent(Longitude.class) || !((Longitude)property.getAnnotation(Longitude.class)).of().equals(spatialAnnotation.name())) continue;
                if (longitudeField != null) {
                    throw log.ambiguousLongitudeDefinition(clazz.getName(), longitudeField, property.getName());
                }
                longitudeField = property.getName();
            }
            List propertyList = clazz.getDeclaredProperties("property");
            for (XProperty property : propertyList) {
                if (property.isAnnotationPresent(Latitude.class) && ((Latitude)property.getAnnotation(Latitude.class)).of().equals(spatialAnnotation.name())) {
                    if (latitudeField != null) {
                        throw log.ambiguousLatitudeDefinition(clazz.getName(), latitudeField, property.getName());
                    }
                    latitudeField = property.getName();
                }
                if (!property.isAnnotationPresent(Longitude.class) || !((Longitude)property.getAnnotation(Longitude.class)).of().equals(spatialAnnotation.name())) continue;
                if (longitudeField != null) {
                    throw log.ambiguousLongitudeDefinition(clazz.getName(), longitudeField, property.getName());
                }
                longitudeField = property.getName();
            }
            spatialBridge = latitudeField != null && longitudeField != null ? this.bridgeFactory.buildSpatialBridge(spatialAnnotation, clazz, latitudeField, longitudeField) : null;
        }
        if (spatialBridge == null) {
            throw log.cannotFindCoordinatesNorLatLongForSpatial(spatialAnnotation.name().isEmpty() ? "default" : spatialAnnotation.name(), clazz.getName());
        }
        return spatialBridge;
    }

    private void initializeMemberLevelAnnotations(String prefix, XProperty member, TypeMetadata.Builder typeMetadataBuilder, boolean disableOptimizations, boolean isRoot, boolean isProvidedId, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        if (!isProvidedId) {
            this.checkDocumentId(member, typeMetadataBuilder, isRoot, prefix, configContext, pathsContext, parseContext);
        }
        this.checkForField(member, typeMetadataBuilder, prefix, configContext, pathsContext, parseContext);
        this.checkForFields(member, typeMetadataBuilder, prefix, configContext, pathsContext, parseContext);
        this.checkForSpatial(member, typeMetadataBuilder, prefix, pathsContext, parseContext);
        this.checkForSpatialsAnnotation(member, typeMetadataBuilder, prefix, pathsContext, parseContext);
        this.checkForAnalyzerDefs((XAnnotatedElement)member, configContext);
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)member, typeMetadataBuilder, configContext);
        this.checkForIndexedEmbedded(member, prefix, disableOptimizations, typeMetadataBuilder, configContext, pathsContext, parseContext);
        this.checkForContainedIn(member, typeMetadataBuilder, parseContext);
    }

    private void checkForContainedIn(XProperty member, TypeMetadata.Builder typeMetadataBuilder, ParseContext parseContext) {
        ContainedIn containedInAnnotation = (ContainedIn)member.getAnnotation(ContainedIn.class);
        if (containedInAnnotation == null) {
            return;
        }
        this.updateContainedInMaxDepths(member, typeMetadataBuilder);
        parseContext.collectUnqualifiedCollectionRole(member.getName());
    }

    private void updateContainedInMaxDepths(XProperty member, TypeMetadata.Builder typeMetadataBuilder) {
        this.updateContainedInMaxDepth((XMember)member, typeMetadataBuilder, "field");
        this.updateContainedInMaxDepth((XMember)member, typeMetadataBuilder, "property");
    }

    private void updateContainedInMaxDepth(XMember memberWithContainedIn, TypeMetadata.Builder typeMetadataBuilder, String accessType) {
        XClass memberReturnedType = memberWithContainedIn.getElementClass();
        String mappedBy = this.mappedBy(memberWithContainedIn);
        List returnedTypeProperties = memberReturnedType.getDeclaredProperties(accessType);
        for (XProperty property : returnedTypeProperties) {
            if (!this.isCorrespondingIndexedEmbedded(mappedBy, property)) continue;
            this.updateDepthProperties(memberWithContainedIn, typeMetadataBuilder, property);
            break;
        }
    }

    private boolean isCorrespondingIndexedEmbedded(String mappedBy, XProperty property) {
        if (!property.isAnnotationPresent(IndexedEmbedded.class)) {
            return false;
        }
        if (mappedBy.isEmpty()) {
            return true;
        }
        return mappedBy.equals(property.getName());
    }

    private void updateDepthProperties(XMember memberWithContainedIn, TypeMetadata.Builder typeMetadataBuilder, XProperty property) {
        int depth = ((IndexedEmbedded)property.getAnnotation(IndexedEmbedded.class)).depth();
        typeMetadataBuilder.addContainedIn(new ContainedInMetadata(memberWithContainedIn, depth));
    }

    private String mappedBy(XMember member) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = member.getAnnotations()) {
            String mappedBy = this.mappedBy(annotation);
            if (!StringHelper.isNotEmpty(mappedBy)) continue;
            return mappedBy;
        }
        return "";
    }

    private String mappedBy(Annotation annotation) {
        try {
            Method declaredMethod = annotation.annotationType().getDeclaredMethod("mappedBy", new Class[0]);
            return (String)declaredMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (SecurityException e) {
            return "";
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
    }

    private void checkForField(XProperty member, TypeMetadata.Builder typeMetadataBuilder, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        Field fieldAnnotation = (Field)member.getAnnotation(Field.class);
        NumericField numericFieldAnnotation = (NumericField)member.getAnnotation(NumericField.class);
        DocumentId idAnn = (DocumentId)member.getAnnotation(DocumentId.class);
        if (fieldAnnotation != null && (this.isFieldInPath(fieldAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            PropertyMetadata.Builder propertyMetadataBuilder = new PropertyMetadata.Builder(member).dynamicBoostStrategy(AnnotationProcessingHelper.getDynamicBoost((XAnnotatedElement)member));
            this.bindFieldAnnotation(prefix, fieldAnnotation, numericFieldAnnotation, typeMetadataBuilder, propertyMetadataBuilder, configContext, parseContext);
            typeMetadataBuilder.addProperty(propertyMetadataBuilder.build());
        }
        if (fieldAnnotation == null && idAnn == null && numericFieldAnnotation != null) {
            throw new SearchException("@NumericField without a @Field on property '" + member.getName() + "'");
        }
    }

    private void bindFieldAnnotation(String prefix, Field fieldAnnotation, NumericField numericFieldAnnotation, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, ConfigContext configContext, ParseContext parseContext) {
        XProperty member = propertyMetadataBuilder.getPropertyAccessor();
        if (this.isPropertyTransient(member, configContext)) {
            typeMetadataBuilder.disableStateInspectionOptimization();
        }
        String fieldName = prefix + ReflectionHelper.getAttributeName((XMember)member, fieldAnnotation.name());
        Store store = fieldAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(fieldAnnotation.index(), fieldAnnotation.analyze(), fieldAnnotation.norms());
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(fieldAnnotation.termVector());
        FieldBridge fieldBridge = this.bridgeFactory.guessType(fieldAnnotation, numericFieldAnnotation, (XMember)member, this.reflectionManager, configContext.getServiceManager());
        String nullToken = this.determineNullToken(fieldAnnotation, configContext);
        if (nullToken != null && fieldBridge instanceof TwoWayFieldBridge) {
            fieldBridge = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)fieldBridge, nullToken);
        }
        Analyzer analyzer = this.determineAnalyzer(fieldAnnotation, member, configContext);
        analyzer = typeMetadataBuilder.addToScopedAnalyzer(fieldName, analyzer, index);
        DocumentFieldMetadata.Builder fieldMetadataBuilder = new DocumentFieldMetadata.Builder(fieldName, store, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, fieldAnnotation)).fieldBridge(fieldBridge).analyzer(analyzer).indexNullAs(nullToken);
        if (numericFieldAnnotation != null) {
            fieldMetadataBuilder.numeric().precisionStep(AnnotationProcessingHelper.getPrecisionStep(numericFieldAnnotation));
        }
        DocumentFieldMetadata fieldMetadata = fieldMetadataBuilder.build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        parseContext.collectUnqualifiedCollectionRole(member.getName());
    }

    private String determineNullToken(Field fieldAnnotation, ConfigContext context) {
        if (fieldAnnotation == null) {
            return null;
        }
        String indexNullAs = fieldAnnotation.indexNullAs();
        if (indexNullAs.equals("__DO_NOT_INDEX_NULL__")) {
            indexNullAs = null;
        } else if (indexNullAs.equals("__DEFAULT_NULL_TOKEN__")) {
            indexNullAs = context.getDefaultNullToken();
        }
        return indexNullAs;
    }

    private Analyzer determineAnalyzer(Field fieldAnnotation, XProperty member, ConfigContext context) {
        Analyzer analyzer = null;
        if (fieldAnnotation != null) {
            analyzer = AnnotationProcessingHelper.getAnalyzer(fieldAnnotation.analyzer(), context);
        }
        if (analyzer == null) {
            analyzer = AnnotationProcessingHelper.getAnalyzer((org.hibernate.search.annotations.Analyzer)member.getAnnotation(org.hibernate.search.annotations.Analyzer.class), context);
        }
        return analyzer;
    }

    private boolean isPropertyTransient(XProperty member, ConfigContext context) {
        Annotation transientAnnotation;
        if (!context.isJpaPresent()) {
            return false;
        }
        try {
            Class transientAnnotationClass = ClassLoaderHelper.classForName("javax.persistence.Transient", this.configContext.getServiceManager());
            transientAnnotation = member.getAnnotation(transientAnnotationClass);
        }
        catch (ClassLoadingException e) {
            throw new SearchException("Unable to load @Transient.class even though it should be present ?!");
        }
        return transientAnnotation != null;
    }

    private void checkForSpatialsAnnotation(XProperty member, TypeMetadata.Builder typeMetadataBuilder, String prefix, PathsContext pathsContext, ParseContext parseContext) {
        Spatials spatialsAnnotation = (Spatials)member.getAnnotation(Spatials.class);
        if (spatialsAnnotation != null) {
            for (Spatial spatialAnnotation : spatialsAnnotation.value()) {
                if (!this.isFieldInPath(spatialAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached()) continue;
                this.bindSpatialAnnotation(spatialAnnotation, prefix, member, typeMetadataBuilder, parseContext);
            }
        }
    }

    private void checkForSpatial(XProperty member, TypeMetadata.Builder typeMetadataBuilder, String prefix, PathsContext pathsContext, ParseContext parseContext) {
        Spatial spatialAnnotation = (Spatial)member.getAnnotation(Spatial.class);
        if (spatialAnnotation != null && (this.isFieldInPath(spatialAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            this.bindSpatialAnnotation(spatialAnnotation, prefix, member, typeMetadataBuilder, parseContext);
        }
    }

    private void checkForAnalyzerDefs(XAnnotatedElement annotatedElement, ConfigContext context) {
        AnalyzerDefs defs = (AnalyzerDefs)annotatedElement.getAnnotation(AnalyzerDefs.class);
        if (defs != null) {
            for (AnalyzerDef def : defs.value()) {
                context.addAnalyzerDef(def, annotatedElement);
            }
        }
        AnalyzerDef def = (AnalyzerDef)annotatedElement.getAnnotation(AnalyzerDef.class);
        context.addAnalyzerDef(def, annotatedElement);
    }

    private void checkForAnalyzerDiscriminator(XAnnotatedElement annotatedElement, TypeMetadata.Builder typeMetadataBuilder, ConfigContext context) {
        AnalyzerDiscriminator discriminatorAnnotation = (AnalyzerDiscriminator)annotatedElement.getAnnotation(AnalyzerDiscriminator.class);
        if (discriminatorAnnotation == null) {
            return;
        }
        if (annotatedElement instanceof XProperty && this.isPropertyTransient((XProperty)annotatedElement, context)) {
            typeMetadataBuilder.disableStateInspectionOptimization();
        }
        Class<? extends Discriminator> discriminatorClass = discriminatorAnnotation.impl();
        Discriminator discriminator = ClassLoaderHelper.instanceFromClass(Discriminator.class, discriminatorClass, "analyzer discriminator implementation");
        if (annotatedElement instanceof XMember) {
            typeMetadataBuilder.analyzerDiscriminator(discriminator, (XMember)annotatedElement);
        } else {
            typeMetadataBuilder.analyzerDiscriminator(discriminator, null);
        }
    }

    private void checkForFields(XProperty member, TypeMetadata.Builder typeMetadataBuilder, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        Fields fieldsAnnotation = (Fields)member.getAnnotation(Fields.class);
        NumericFields numericFieldsAnnotations = (NumericFields)member.getAnnotation(NumericFields.class);
        if (fieldsAnnotation != null) {
            for (Field fieldAnnotation : fieldsAnnotation.value()) {
                if (!this.isFieldInPath(fieldAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached()) continue;
                PropertyMetadata.Builder propertyMetadataBuilder = new PropertyMetadata.Builder(member).dynamicBoostStrategy(AnnotationProcessingHelper.getDynamicBoost((XAnnotatedElement)member));
                this.bindFieldAnnotation(prefix, fieldAnnotation, this.getNumericExtension(fieldAnnotation, numericFieldsAnnotations), typeMetadataBuilder, propertyMetadataBuilder, configContext, parseContext);
                typeMetadataBuilder.addProperty(propertyMetadataBuilder.build());
            }
        }
    }

    private NumericField getNumericExtension(Field fieldAnnotation, NumericFields numericFields) {
        if (numericFields == null) {
            return null;
        }
        for (NumericField numericField : numericFields.value()) {
            if (!numericField.forField().equals(fieldAnnotation.name())) continue;
            return numericField;
        }
        return null;
    }

    private boolean isFieldInPath(Annotation fieldAnnotation, XProperty member, PathsContext pathsContext, String prefix) {
        String path;
        if (pathsContext != null && pathsContext.containsPath(path = prefix + this.fieldName(fieldAnnotation, member))) {
            pathsContext.markEncounteredPath(path);
            return true;
        }
        return false;
    }

    private String fieldName(Annotation fieldAnnotation, XProperty member) {
        if (fieldAnnotation == null) {
            return member.getName();
        }
        String fieldName = AnnotationProcessingHelper.getFieldName(fieldAnnotation);
        if (fieldName == null || fieldName.isEmpty()) {
            return member.getName();
        }
        return fieldName;
    }

    private void checkForIndexedEmbedded(XProperty member, String prefix, boolean disableOptimizations, TypeMetadata.Builder typeMetadataBuilder, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        IndexedEmbedded indexedEmbeddedAnnotation = (IndexedEmbedded)member.getAnnotation(IndexedEmbedded.class);
        if (indexedEmbeddedAnnotation == null) {
            return;
        }
        parseContext.collectUnqualifiedCollectionRole(member.getName());
        int oldMaxLevel = parseContext.getMaxLevel();
        int potentialLevel = this.depth(indexedEmbeddedAnnotation) + parseContext.getLevel();
        if (potentialLevel < 0) {
            potentialLevel = Integer.MAX_VALUE;
        }
        if (potentialLevel < oldMaxLevel) {
            parseContext.setMaxLevel(potentialLevel);
        }
        parseContext.incrementLevel();
        XClass elementClass = Void.TYPE == indexedEmbeddedAnnotation.targetElement() ? member.getElementClass() : this.reflectionManager.toXClass(indexedEmbeddedAnnotation.targetElement());
        if (parseContext.getMaxLevel() == Integer.MAX_VALUE && parseContext.hasBeenProcessed(elementClass)) {
            throw new SearchException("Circular reference. Duplicate use of " + elementClass.getName() + " in root entity " + typeMetadataBuilder.getClass().getName() + "#" + this.buildEmbeddedPrefix(prefix, indexedEmbeddedAnnotation, member));
        }
        String localPrefix = this.buildEmbeddedPrefix(prefix, indexedEmbeddedAnnotation, member);
        PathsContext updatedPathsContext = this.updatePaths(localPrefix, pathsContext, indexedEmbeddedAnnotation);
        boolean pathsCreatedAtThisLevel = false;
        if (pathsContext == null && updatedPathsContext != null) {
            pathsCreatedAtThisLevel = true;
        }
        if (!parseContext.isMaxLevelReached() || this.isInPath(localPrefix, updatedPathsContext, indexedEmbeddedAnnotation)) {
            parseContext.processingClass(elementClass);
            EmbeddedTypeMetadata.Builder embeddedTypeMetadataBuilder = new EmbeddedTypeMetadata.Builder(this.reflectionManager.toClass(elementClass), (XMember)member, typeMetadataBuilder.getScopedAnalyzer());
            embeddedTypeMetadataBuilder.boost(AnnotationProcessingHelper.getBoost(member, null).floatValue());
            Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((org.hibernate.search.annotations.Analyzer)member.getAnnotation(org.hibernate.search.annotations.Analyzer.class), configContext);
            if (analyzer == null) {
                analyzer = typeMetadataBuilder.getAnalyzer();
            }
            embeddedTypeMetadataBuilder.analyzer(analyzer);
            if (disableOptimizations) {
                typeMetadataBuilder.blacklistForOptimization(elementClass);
            }
            XClass previousClass = parseContext.getCurrentClass();
            parseContext.setCurrentClass(elementClass);
            this.initializeClass(embeddedTypeMetadataBuilder, false, localPrefix, parseContext, configContext, disableOptimizations, updatedPathsContext);
            parseContext.setCurrentClass(previousClass);
            String indexNullAs = this.embeddedNullToken(configContext, indexedEmbeddedAnnotation);
            if (indexNullAs != null) {
                NullEncodingFieldBridge fieldBridge = new NullEncodingFieldBridge(NULL_EMBEDDED_STRING_BRIDGE, indexNullAs);
                embeddedTypeMetadataBuilder.indexNullToken(indexNullAs, this.embeddedNullField(localPrefix), fieldBridge);
            }
            EmbeddedTypeMetadata embeddedTypeMetadata = embeddedTypeMetadataBuilder.build();
            for (XClass xClass : embeddedTypeMetadata.getOptimizationBlackList()) {
                typeMetadataBuilder.blacklistForOptimization(xClass);
            }
            typeMetadataBuilder.addEmbeddedType(embeddedTypeMetadata);
            parseContext.removeProcessedClass(elementClass);
        } else if (log.isTraceEnabled()) {
            log.tracef("depth reached, ignoring %s", localPrefix);
        }
        parseContext.decrementLevel();
        parseContext.setMaxLevel(oldMaxLevel);
        if (pathsCreatedAtThisLevel) {
            this.validateAllPathsEncountered(member, updatedPathsContext);
        }
    }

    private int depth(IndexedEmbedded embeddedAnn) {
        if (this.isDepthNotSet(embeddedAnn) && embeddedAnn.includePaths().length > 0) {
            return 0;
        }
        return embeddedAnn.depth();
    }

    private boolean isDepthNotSet(IndexedEmbedded embeddedAnn) {
        return Integer.MAX_VALUE == embeddedAnn.depth();
    }

    private boolean isInPath(String localPrefix, PathsContext pathsContext, IndexedEmbedded embeddedAnn) {
        if (pathsContext != null) {
            boolean defaultPrefix = this.isDefaultPrefix(embeddedAnn);
            Iterator i$ = pathsContext.pathsEncounteredState.keySet().iterator();
            while (i$.hasNext()) {
                String path;
                String app = path = (String)i$.next();
                if (defaultPrefix) {
                    app = app + ".";
                }
                if (!app.startsWith(localPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    private PathsContext updatePaths(String localPrefix, PathsContext pathsContext, IndexedEmbedded embeddedAnn) {
        if (pathsContext != null) {
            return pathsContext;
        }
        PathsContext newPathsContext = new PathsContext(embeddedAnn);
        for (String path : embeddedAnn.includePaths()) {
            newPathsContext.addPath(localPrefix + path);
        }
        return newPathsContext;
    }

    private String buildEmbeddedPrefix(String prefix, IndexedEmbedded indexedEmbeddedAnnotation, XProperty member) {
        String localPrefix = prefix;
        localPrefix = this.isDefaultPrefix(indexedEmbeddedAnnotation) ? localPrefix + member.getName() + '.' : localPrefix + indexedEmbeddedAnnotation.prefix();
        return localPrefix;
    }

    private boolean isDefaultPrefix(IndexedEmbedded indexedEmbeddedAnnotation) {
        return ".".equals(indexedEmbeddedAnnotation.prefix());
    }

    private String embeddedNullField(String localPrefix) {
        if (localPrefix.endsWith(".")) {
            return localPrefix.substring(0, localPrefix.length() - 1);
        }
        return localPrefix;
    }

    private void validateAllPathsEncountered(XProperty member, PathsContext updatedPathsContext) {
        Set<String> unEncounteredPaths = updatedPathsContext.getUnencounteredPaths();
        if (unEncounteredPaths.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String prefix = updatedPathsContext.embeddedAnn.prefix();
            for (String path : unEncounteredPaths) {
                sb.append(this.removeLeadingPrefixFromPath(path, prefix));
                sb.append(',');
            }
            String invalidPaths = sb.substring(0, sb.length() - 1);
            throw log.invalidIncludePathConfiguration(member.getName(), member.getDeclaringClass().getName(), invalidPaths);
        }
    }

    private String removeLeadingPrefixFromPath(String path, String prefix) {
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    private String embeddedNullToken(ConfigContext context, IndexedEmbedded indexedEmbeddedAnnotation) {
        String indexNullAs = indexedEmbeddedAnnotation.indexNullAs();
        if ("__DO_NOT_INDEX_NULL__".equals(indexNullAs)) {
            return null;
        }
        if ("__DEFAULT_NULL_TOKEN__".equals(indexNullAs)) {
            return context.getDefaultNullToken();
        }
        return indexNullAs;
    }

    boolean stateInspectionOptimizationsEnabled(TypeMetadata.Builder typeMetadataBuilder) {
        if (!typeMetadataBuilder.isStateInspectionOptimizationsEnabled()) {
            return false;
        }
        if (typeMetadataBuilder.areClassBridgesUsed()) {
            log.tracef("State inspection optimization disabled as entity %s uses class bridges", typeMetadataBuilder.getIndexedType().getName());
            return false;
        }
        BoostStrategy boostStrategy = typeMetadataBuilder.getClassBoostStrategy();
        if (boostStrategy != null && !(boostStrategy instanceof DefaultBoostStrategy)) {
            log.tracef("State inspection optimization disabled as DynamicBoost is enabled on entity %s", typeMetadataBuilder.getIndexedType().getName());
            return false;
        }
        return true;
    }

    public static final class ParseContext {
        private final Set<XClass> processedClasses = new HashSet<XClass>();
        private final Set<String> spatialNames = new TreeSet<String>();
        private XClass currentClass;
        private int level = 0;
        private int maxLevel = Integer.MAX_VALUE;
        private boolean explicitDocumentId = false;
        private final Set<String> unqualifiedCollectedCollectionRoles = new HashSet<String>();

        boolean hasBeenProcessed(XClass processedClass) {
            return this.processedClasses.contains(processedClass);
        }

        void processingClass(XClass processedClass) {
            this.processedClasses.add(processedClass);
        }

        void removeProcessedClass(XClass processedClass) {
            this.processedClasses.remove(processedClass);
        }

        boolean isSpatialNameUsed(String name) {
            return this.spatialNames.contains(name);
        }

        void markSpatialNameAsUsed(String name) {
            this.spatialNames.add(name);
        }

        public XClass getCurrentClass() {
            return this.currentClass;
        }

        public void setCurrentClass(XClass currentClass) {
            this.currentClass = currentClass;
        }

        boolean isMaxLevelReached() {
            return this.level > this.maxLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public void setMaxLevel(int newMaxLevel) {
            this.maxLevel = newMaxLevel;
        }

        public int getLevel() {
            return this.level;
        }

        public void incrementLevel() {
            ++this.level;
        }

        public void decrementLevel() {
            --this.level;
        }

        public boolean isExplicitDocumentId() {
            return this.explicitDocumentId;
        }

        public void setExplicitDocumentId(boolean explicitDocumentId) {
            this.explicitDocumentId = explicitDocumentId;
        }

        public Set<String> getCollectedUnqualifiedCollectionRoles() {
            return this.unqualifiedCollectedCollectionRoles;
        }

        public void collectUnqualifiedCollectionRole(String unqualifiedCollectionRole) {
            this.unqualifiedCollectedCollectionRoles.add(unqualifiedCollectionRole);
        }
    }

    static class PathsContext {
        private final IndexedEmbedded embeddedAnn;
        private final Map<String, Boolean> pathsEncounteredState = new HashMap<String, Boolean>();

        public PathsContext(IndexedEmbedded embeddedAnn) {
            this.embeddedAnn = embeddedAnn;
        }

        public boolean containsPath(String path) {
            return this.pathsEncounteredState.keySet().contains(path);
        }

        public void addPath(String path) {
            this.pathsEncounteredState.put(path, Boolean.FALSE);
        }

        public void markEncounteredPath(String path) {
            this.pathsEncounteredState.put(path, Boolean.TRUE);
        }

        public Set<String> getUnencounteredPaths() {
            HashSet<String> unencounteredPaths = new HashSet<String>();
            for (String path : this.pathsEncounteredState.keySet()) {
                if (!this.notEncountered(path)) continue;
                unencounteredPaths.add(path);
            }
            return unencounteredPaths;
        }

        private boolean notEncountered(String path) {
            return this.pathsEncounteredState.get(path) == false;
        }
    }
}

