/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;

public final class StringFieldLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private BinaryDocValues currentCache;

    public StringFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(AtomicReaderContext context) throws IOException {
        AtomicReader reader = context.reader();
        this.currentCache = FieldCache.DEFAULT.getTerms(reader, this.fieldName, false);
    }

    @Override
    public String collect(int relativeDocId) {
        BytesRef term = new BytesRef();
        this.currentCache.get(relativeDocId, term);
        return term.utf8ToString();
    }
}

