/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.hibernate.search.store.impl.FSMasterDirectoryProvider;
import org.hibernate.search.store.impl.FSSlaveDirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public final class DirectoryProviderFactory {
    private static final Map<String, String> defaultProviderClasses = new HashMap<String, String>(6);

    private DirectoryProviderFactory() {
    }

    public static DirectoryProvider<?> createDirectoryProvider(String directoryProviderName, Properties indexProps, WorkerBuildContext context) {
        DirectoryProvider provider;
        String className = indexProps.getProperty("directory_provider", "");
        String maybeShortCut = className.toLowerCase();
        ServiceManager serviceManager = context.getServiceManager();
        if (defaultProviderClasses.containsKey(maybeShortCut)) {
            String fullClassName = defaultProviderClasses.get(maybeShortCut);
            provider = ClassLoaderHelper.instanceFromName(DirectoryProvider.class, fullClassName, "directory provider", serviceManager);
        } else {
            provider = ClassLoaderHelper.instanceFromName(DirectoryProvider.class, className, "directory provider", serviceManager);
        }
        try {
            provider.initialize(directoryProviderName, indexProps, context);
        }
        catch (Exception e) {
            throw new SearchException("Unable to initialize directory provider: " + directoryProviderName, e);
        }
        return provider;
    }

    static {
        defaultProviderClasses.put("", FSDirectoryProvider.class.getName());
        defaultProviderClasses.put("filesystem", FSDirectoryProvider.class.getName());
        defaultProviderClasses.put("filesystem-master", FSMasterDirectoryProvider.class.getName());
        defaultProviderClasses.put("filesystem-slave", FSSlaveDirectoryProvider.class.getName());
        defaultProviderClasses.put("ram", RAMDirectoryProvider.class.getName());
        defaultProviderClasses.put("infinispan", "org.hibernate.search.infinispan.impl.InfinispanDirectoryProvider");
    }
}

