/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Self;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.logging.Log;

public abstract class TableManipulationConfigurationBuilder<B extends AbstractJdbcStoreConfigurationBuilder<?, B>, S extends TableManipulationConfigurationBuilder<B, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<B>
implements Builder<TableManipulationConfiguration>,
Self<S> {
    private static final Log log = (Log)LogFactory.getLog(TableManipulationConfigurationBuilder.class, Log.class);
    private int batchSize = 128;
    private int fetchSize = 100;
    private boolean createOnStart = true;
    private boolean dropOnExit = false;
    private String cacheName;
    private String idColumnName;
    private String idColumnType;
    private String dataColumnName;
    private String dataColumnType;
    private String timestampColumnName;
    private String timestampColumnType;
    String tableNamePrefix;

    TableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, B> builder) {
        super(builder);
    }

    public S batchSize(int batchSize) {
        this.batchSize = batchSize;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S tableNamePrefix(String tableNamePrefix) {
        this.tableNamePrefix = tableNamePrefix;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S createOnStart(boolean createOnStart) {
        this.createOnStart = createOnStart;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dropOnExit(boolean dropOnExit) {
        this.dropOnExit = dropOnExit;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S idColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S idColumnType(String idColumnType) {
        this.idColumnType = idColumnType;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dataColumnName(String dataColumnName) {
        this.dataColumnName = dataColumnName;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dataColumnType(String dataColumnType) {
        this.dataColumnType = dataColumnType;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S timestampColumnName(String timestampColumnName) {
        this.timestampColumnName = timestampColumnName;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S timestampColumnType(String timestampColumnType) {
        this.timestampColumnType = timestampColumnType;
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public void validate() {
        this.validateIfSet("idColumnName", this.idColumnName);
        this.validateIfSet("idColumnType", this.idColumnType);
        this.validateIfSet("dataColumnName", this.dataColumnName);
        this.validateIfSet("dataColumnType", this.dataColumnType);
        this.validateIfSet("timestampColumnName", this.timestampColumnName);
        this.validateIfSet("timestampColumnType", this.timestampColumnType);
        this.validateIfSet("tableNamePrefix", this.tableNamePrefix);
    }

    private void validateIfSet(String name, String value) {
        if (value == null || value.isEmpty()) {
            throw log.tableManipulationAttributeNotSet(name);
        }
    }

    public TableManipulationConfiguration create() {
        return new TableManipulationConfiguration(this.idColumnName, this.idColumnType, this.tableNamePrefix, this.cacheName, this.dataColumnName, this.dataColumnType, this.timestampColumnName, this.timestampColumnType, this.fetchSize, this.batchSize, this.createOnStart, this.dropOnExit);
    }

    public Builder<?> read(TableManipulationConfiguration template) {
        this.batchSize = template.batchSize();
        this.fetchSize = template.fetchSize();
        this.createOnStart = template.createOnStart();
        this.dropOnExit = template.dropOnExit();
        this.idColumnName = template.idColumnName();
        this.idColumnType = template.idColumnType();
        this.dataColumnName = template.dataColumnName();
        this.dataColumnType = template.dataColumnType();
        this.timestampColumnName = template.timestampColumnName();
        this.timestampColumnType = template.timestampColumnType();
        this.cacheName = template.cacheName();
        this.tableNamePrefix = template.tableNamePrefix();
        return this;
    }
}

