/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.Responses;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean
public abstract class Discovery
extends Protocol {
    @Deprecated
    @Property(description="Timeout to wait for the initial members", deprecatedMessage="GMS.join_timeout should be used instead")
    protected long timeout = 3000L;
    @Deprecated
    @Property(description="Minimum number of initial members to get a response from", deprecatedMessage="will be ignored")
    protected int num_initial_members = 10;
    @Deprecated
    @Property(description="Minimum number of server responses (PingData.isServer()=true). If this value is greater than 0, we'll ignore num_initial_members", deprecatedMessage="not used anymore")
    protected int num_initial_srv_members;
    @Property(description="Return from the discovery phase as soon as we have 1 coordinator response")
    protected boolean break_on_coord_rsp = true;
    @Property(description="Whether or not to return the entire logical-physical address cache mappings on a discovery request, or not.")
    protected boolean return_entire_cache = false;
    @Property(description="If greater than 0, we'll wait a random number of milliseconds in range [0..stagger_timeout] before sending a discovery response. This prevents traffic spikes in large clusters when everyone sends their discovery response at the same time")
    protected long stagger_timeout;
    @Property(description="Always sends a discovery response, no matter what", writable=true)
    protected boolean force_sending_discovery_rsps = true;
    @Property(description="If a persistent disk cache (PDC) is present, combine the discovery results with the contents of the disk cache before returning the results")
    protected boolean use_disk_cache = false;
    @Deprecated
    @Property(description="When sending a discovery request, always send the physical address and logical name too", deprecatedMessage="ignored")
    protected boolean always_send_physical_addr_with_discovery_request = true;
    @Property(description="Max size of the member list shipped with a discovery request. If we have more, the mbrs field in the discovery request header is nulled and members return the entire membership, not individual members")
    protected int max_members_in_discovery_request = 500;
    @Property(description="Expiry time of discovery responses in ms")
    protected long discovery_rsp_expiry_time = 60000L;
    @Property(description="If true then the discovery is done on a separate timer thread. Should be set to true when discovery is blocking and/or takes more than a few milliseconds")
    protected boolean async_discovery = false;
    @ManagedAttribute(description="Total number of discovery requests sent ")
    protected int num_discovery_requests;
    protected volatile boolean is_server = false;
    protected volatile boolean is_leaving = false;
    protected TimeScheduler timer;
    protected View view;
    protected final List<Address> members = new ArrayList<Address>(11);
    @ManagedAttribute(description="Whether this member is the current coordinator")
    protected boolean is_coord = false;
    protected Address local_addr = null;
    protected Address current_coord;
    protected String cluster_name;
    protected final Map<Long, Responses> ping_responses = new HashMap<Long, Responses>();
    @ManagedAttribute(description="Whether the transport supports multicasting")
    protected boolean transport_supports_multicasting = true;

    @ManagedOperation(description="Sets force_sending_discovery_rsps")
    public void setForceSendingDiscoveryRsps(boolean flag) {
        this.force_sending_discovery_rsps = flag;
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        if (this.stagger_timeout < 0L) {
            throw new IllegalArgumentException("stagger_timeout cannot be negative");
        }
        this.transport_supports_multicasting = this.getTransport().supportsMulticasting();
    }

    public abstract boolean isDynamic();

    public void handleDisconnect() {
    }

    public void handleConnect() {
    }

    public void discoveryRequestReceived(Address sender, String logical_name, PhysicalAddress physical_addr) {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Deprecated
    public int getNumInitialMembers() {
        return -1;
    }

    @Deprecated
    public void setNumInitialMembers(int num) {
    }

    public int getNumberOfDiscoveryRequestsSent() {
        return this.num_discovery_requests;
    }

    public long timeout() {
        return this.timeout;
    }

    public Discovery timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Deprecated
    public long numInitialMembers() {
        return -1L;
    }

    @Deprecated
    public Discovery numInitialMembers(int num) {
        return this;
    }

    public boolean breakOnCoordResponse() {
        return this.break_on_coord_rsp;
    }

    public Discovery breakOnCoordResponse(boolean flag) {
        this.break_on_coord_rsp = flag;
        return this;
    }

    public boolean returnEntireCache() {
        return this.return_entire_cache;
    }

    public Discovery returnEntireCache(boolean flag) {
        this.return_entire_cache = flag;
        return this;
    }

    public long staggerTimeout() {
        return this.stagger_timeout;
    }

    public Discovery staggerTimeout(long timeout) {
        this.stagger_timeout = timeout;
        return this;
    }

    public boolean forceDiscoveryResponses() {
        return this.force_sending_discovery_rsps;
    }

    public Discovery forceDiscoveryResponses(boolean f) {
        this.force_sending_discovery_rsps = f;
        return this;
    }

    public boolean useDiskCache() {
        return this.use_disk_cache;
    }

    public Discovery useDiskCache(boolean flag) {
        this.use_disk_cache = flag;
        return this;
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.getViewId().toString() : "null";
    }

    public ViewId getViewId() {
        return this.view != null ? this.view.getViewId() : null;
    }

    @ManagedAttribute(description="The address of the current coordinator")
    public String getCurrentCoord() {
        return this.current_coord != null ? this.current_coord.toString() : "n/a";
    }

    protected boolean isMergeRunning() {
        Object retval = this.up_prot.up(new Event(100));
        return retval instanceof Boolean && (Boolean)retval != false;
    }

    @Override
    public List<Integer> providedUpServices() {
        return Arrays.asList(12, 87, 11);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_discovery_requests = 0;
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() {
        this.is_server = false;
    }

    protected abstract void findMembers(List<Address> var1, boolean var2, Responses var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Responses findMembers(final List<Address> members, final boolean initial_discovery, boolean async) {
        ++this.num_discovery_requests;
        int size = members != null ? members.size() : 16;
        final Responses rsps = new Responses(size, initial_discovery && this.break_on_coord_rsp, size);
        Map<Long, Responses> map = this.ping_responses;
        synchronized (map) {
            this.ping_responses.put(System.currentTimeMillis(), rsps);
        }
        if (async || this.async_discovery) {
            this.timer.execute(new Runnable(){

                @Override
                public void run() {
                    Discovery.this.findMembers((List<Address>)members, initial_discovery, rsps);
                }
            });
        } else {
            this.findMembers(members, initial_discovery, rsps);
        }
        return rsps;
    }

    @ManagedOperation(description="Runs the discovery protocol to find initial members")
    public String findInitialMembersAsString() {
        Responses rsps = this.findMembers(null, false, false);
        if (!rsps.isDone()) {
            rsps.waitFor(300L);
        }
        if (rsps.isEmpty()) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        for (PingData rsp : rsps) {
            sb.append(rsp).append("\n");
        }
        return sb.toString();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                PingHeader hdr = (PingHeader)msg.getHeader(this.id);
                if (hdr == null) {
                    return this.up_prot.up(evt);
                }
                if (this.is_leaving) {
                    return null;
                }
                PingData data = this.readPingData(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                Address logical_addr = data != null ? data.getAddress() : msg.src();
                switch (hdr.type) {
                    case 1: {
                        boolean send_response;
                        if (this.cluster_name == null || hdr.cluster_name == null) {
                            this.log.warn("cluster_name (%s) or cluster_name of header (%s) is null; passing up discovery request from %s, but this should not be the case", this.cluster_name, hdr.cluster_name, msg.src());
                        } else if (!this.cluster_name.equals(hdr.cluster_name)) {
                            this.log.warn("%s: discarding discovery request for cluster '%s' from %s; our cluster name is '%s'. Please separate your clusters properly", logical_addr, hdr.cluster_name, msg.src(), this.cluster_name);
                            return null;
                        }
                        if (data != null) {
                            this.addDiscoveryResponseToCaches(logical_addr, data.getLogicalName(), data.getPhysicalAddr());
                            this.discoveryRequestReceived(msg.getSrc(), data.getLogicalName(), data.getPhysicalAddr());
                            this.addResponse(data, false);
                        }
                        if (this.return_entire_cache) {
                            Map cache = (Map)this.down(new Event(88));
                            if (cache != null) {
                                for (Map.Entry entry : cache.entrySet()) {
                                    Address addr = (Address)entry.getKey();
                                    if (!addr.equals(this.local_addr) && !this.members.contains(addr)) continue;
                                    PhysicalAddress physical_addr = (PhysicalAddress)entry.getValue();
                                    this.sendDiscoveryResponse(addr, physical_addr, UUID.get(addr), msg.getSrc(), this.isCoord(addr));
                                }
                            }
                            return null;
                        }
                        Collection<? extends Address> mbrs = data != null ? data.mbrs() : null;
                        boolean bl = send_response = mbrs == null || mbrs.contains(this.local_addr);
                        if (send_response) {
                            PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
                            this.sendDiscoveryResponse(this.local_addr, physical_addr, UUID.get(this.local_addr), msg.getSrc(), this.is_coord);
                        }
                        return null;
                    }
                    case 2: {
                        if (data != null) {
                            this.log.trace("%s: received GET_MBRS_RSP from %s: %s", this.local_addr, msg.src(), data);
                            this.handleDiscoveryResponse(data, msg.src());
                        }
                        return null;
                    }
                }
                this.log.warn("got PING header with unknown type %d", hdr.type);
                return null;
            }
            case 11: {
                return this.findMembers((List<Address>)((List)evt.getArg()), false, true);
            }
        }
        return this.up_prot.up(evt);
    }

    protected void handleDiscoveryResponse(PingData data, Address sender) {
        Address logical_addr = data.getAddress() != null ? data.getAddress() : sender;
        this.addDiscoveryResponseToCaches(logical_addr, data.getLogicalName(), data.getPhysicalAddr());
        boolean overwrite = logical_addr != null && logical_addr.equals(sender);
        this.addResponse(data, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                return this.findMembers(null, true, false);
            }
            case 11: {
                return this.findMembers((List<Address>)((List)evt.getArg()), false, false);
            }
            case 6: {
                this.view = (View)evt.getArg();
                List<Address> tmp = this.view.getMembers();
                if (tmp != null) {
                    List<Address> list = this.members;
                    synchronized (list) {
                        this.members.clear();
                        this.members.addAll(tmp);
                    }
                }
                this.current_coord = !this.members.isEmpty() ? this.members.get(0) : null;
                this.is_coord = this.current_coord != null && this.local_addr != null && this.current_coord.equals(this.local_addr);
                return this.down_prot.down(evt);
            }
            case 16: {
                this.down_prot.down(evt);
                this.is_server = true;
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                return this.down_prot.down(evt);
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.is_leaving = false;
                this.cluster_name = (String)evt.getArg();
                Object ret = this.down_prot.down(evt);
                this.handleConnect();
                return ret;
            }
            case 4: {
                this.is_leaving = true;
                this.handleDisconnect();
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResponse(PingData rsp, boolean overwrite) {
        Map<Long, Responses> map = this.ping_responses;
        synchronized (map) {
            Iterator<Map.Entry<Long, Responses>> it = this.ping_responses.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Responses> entry = it.next();
                long timestamp = entry.getKey();
                Responses rsps = entry.getValue();
                rsps.addResponse(rsp, overwrite);
                if (!rsps.isDone() && System.currentTimeMillis() - timestamp <= this.discovery_rsp_expiry_time) continue;
                it.remove();
            }
        }
    }

    protected boolean addDiscoveryResponseToCaches(Address mbr, String logical_name, PhysicalAddress physical_addr) {
        if (mbr == null) {
            return false;
        }
        if (logical_name != null) {
            UUID.add(mbr, logical_name);
        }
        if (physical_addr != null) {
            return (Boolean)this.down(new Event(89, new Tuple<Address, PhysicalAddress>(mbr, physical_addr)));
        }
        return false;
    }

    protected byte[] serializeWithoutView(PingData data) {
        PingData clone = new PingData(data.getAddress(), data.isServer(), data.getLogicalName(), data.getPhysicalAddr()).coord(data.isCoord());
        try {
            return Util.streamableToByteBuffer(clone);
        }
        catch (Exception e) {
            this.log.error("error serializing PingData", e);
            return null;
        }
    }

    protected static PingData deserialize(byte[] data) throws Exception {
        return (PingData)Util.streamableFromByteBuffer(PingData.class, data);
    }

    public static Buffer marshal(PingData data) {
        return Util.streamableToBuffer(data);
    }

    protected PingData readPingData(byte[] buffer, int offset, int length) {
        try {
            return buffer != null ? Util.streamableFromBuffer(PingData.class, buffer, offset, length) : null;
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading PingData from message: %s", this.local_addr, ex);
            return null;
        }
    }

    protected void sendDiscoveryResponse(Address logical_addr, PhysicalAddress physical_addr, String logical_name, final Address sender, boolean coord) {
        final PingData data = new PingData(logical_addr, this.is_server, logical_name, physical_addr).coord(coord);
        final Message rsp_msg = new Message(sender).setFlag(Message.Flag.INTERNAL, Message.Flag.OOB, Message.Flag.DONT_BUNDLE).putHeader(this.id, new PingHeader(2)).setBuffer(Discovery.marshal(data));
        if (this.stagger_timeout > 0L) {
            int view_size = this.view != null ? this.view.size() : 10;
            int rank = Util.getRank(this.view, this.local_addr);
            long sleep_time = rank == 0 ? Util.random(this.stagger_timeout) : this.stagger_timeout * (long)rank / (long)view_size - this.stagger_timeout / (long)view_size;
            this.timer.schedule(new Runnable(){

                @Override
                public void run() {
                    Discovery.this.log.trace("%s: received GET_MBRS_REQ from %s, sending staggered response %s", Discovery.this.local_addr, sender, data);
                    Discovery.this.down_prot.down(new Event(1, rsp_msg));
                }
            }, sleep_time, TimeUnit.MILLISECONDS);
            return;
        }
        this.log.trace("%s: received GET_MBRS_REQ from %s, sending response %s", this.local_addr, sender, data);
        this.down_prot.down(new Event(1, rsp_msg));
    }

    protected static String addressAsString(Address address) {
        if (address == null) {
            return "";
        }
        if (address instanceof UUID) {
            return ((UUID)address).toStringLong();
        }
        return address.toString();
    }

    protected boolean isCoord(Address member) {
        return member.equals(this.current_coord);
    }
}

