/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class PingData
implements SizeStreamable {
    protected Address sender;
    protected byte flags;
    protected String logical_name;
    protected PhysicalAddress physical_addr;
    protected Collection<? extends Address> mbrs;
    protected static final byte is_coord = 1;
    protected static final byte is_server = 2;

    public PingData() {
    }

    public PingData(Address sender, boolean is_server) {
        this.sender = sender;
        this.server(is_server);
    }

    @Deprecated
    public PingData(Address sender, View view, boolean is_server, String logical_name, Collection<PhysicalAddress> physical_addrs) {
        this(sender, is_server);
        this.logical_name = logical_name;
        if (physical_addrs != null && !physical_addrs.isEmpty()) {
            this.physical_addr = physical_addrs.iterator().next();
        }
    }

    public PingData(Address sender, boolean is_server, String logical_name, PhysicalAddress physical_addr) {
        this(sender, is_server);
        this.logical_name = logical_name;
        this.physical_addr = physical_addr;
    }

    @Deprecated
    public PingData(Address sender, View view, ViewId view_id, boolean is_server, String logical_name, Collection<PhysicalAddress> physical_addrs) {
        this(sender, is_server, logical_name, physical_addrs == null || physical_addrs.isEmpty() ? null : physical_addrs.iterator().next());
    }

    public PingData coord(boolean c) {
        if (c) {
            this.flags = Util.setFlag(this.flags, (byte)1);
            this.flags = Util.setFlag(this.flags, (byte)2);
        } else {
            this.flags = Util.clearFlags(this.flags, (byte)1);
        }
        return this;
    }

    public PingData server(boolean c) {
        this.flags = c ? Util.setFlag(this.flags, (byte)2) : Util.clearFlags(this.flags, (byte)2);
        return this;
    }

    public boolean isCoord() {
        return Util.isFlagSet(this.flags, (byte)1);
    }

    public boolean isServer() {
        return Util.isFlagSet(this.flags, (byte)2) || Util.isFlagSet(this.flags, (byte)1);
    }

    public Address getAddress() {
        return this.sender;
    }

    public String getLogicalName() {
        return this.logical_name;
    }

    @Deprecated
    public Collection<PhysicalAddress> getPhysicalAddrs() {
        return Arrays.asList(this.physical_addr);
    }

    public PhysicalAddress getPhysicalAddr() {
        return this.physical_addr;
    }

    public PingData mbrs(Collection<? extends Address> mbrs) {
        this.mbrs = mbrs;
        return this;
    }

    public Collection<? extends Address> mbrs() {
        return this.mbrs;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PingData)) {
            return false;
        }
        PingData other = (PingData)obj;
        return this.sender != null && this.sender.equals(other.sender);
    }

    public int hashCode() {
        int retval = 0;
        if (this.sender != null) {
            retval += this.sender.hashCode();
        }
        if (retval == 0) {
            retval = super.hashCode();
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sender);
        if (this.logical_name != null) {
            sb.append(", name=").append(this.logical_name);
        }
        if (this.physical_addr != null) {
            sb.append(", addr=").append(this.physical_addr);
        }
        if (this.isCoord()) {
            sb.append(", coord");
        } else if (this.isServer()) {
            sb.append(", server");
        }
        if (this.mbrs != null) {
            sb.append(", mbrs=" + this.mbrs.size());
        }
        return sb.toString();
    }

    @Override
    public int size() {
        int retval = 1;
        retval += Util.size(this.sender);
        ++retval;
        if (this.logical_name != null) {
            retval += this.logical_name.length() + 2;
        }
        retval += Util.size(this.physical_addr);
        retval = (int)((long)retval + Util.size(this.mbrs));
        return retval;
    }

    @Override
    public void writeTo(DataOutput outstream) throws Exception {
        Util.writeAddress(this.sender, outstream);
        outstream.writeByte(this.flags);
        Bits.writeString(this.logical_name, outstream);
        Util.writeAddress(this.physical_addr, outstream);
        Util.writeAddresses(this.mbrs, outstream);
    }

    @Override
    public void readFrom(DataInput instream) throws Exception {
        this.sender = Util.readAddress(instream);
        this.flags = instream.readByte();
        this.logical_name = Bits.readString(instream);
        this.physical_addr = (PhysicalAddress)Util.readAddress(instream);
        this.mbrs = Util.readAddresses(instream, ArrayList.class);
    }
}

