/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.StateChangingEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryFactoryImpl
implements EntryFactory {
    private static final Log log = LogFactory.getLog(EntryFactoryImpl.class);
    private final boolean trace = log.isTraceEnabled();
    protected boolean useRepeatableRead;
    private DataContainer container;
    protected boolean clusterModeWriteSkewCheck;
    private boolean isL1Enabled;
    private Configuration configuration;
    private CacheNotifier notifier;
    private DistributionManager distributionManager;

    @Inject
    public void injectDependencies(DataContainer dataContainer, Configuration configuration, CacheNotifier notifier, DistributionManager distributionManager) {
        this.container = dataContainer;
        this.configuration = configuration;
        this.notifier = notifier;
        this.distributionManager = distributionManager;
    }

    @Start(priority=8)
    public void init() {
        this.useRepeatableRead = this.configuration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        this.clusterModeWriteSkewCheck = this.useRepeatableRead && this.configuration.locking().writeSkewCheck() && this.configuration.clustering().cacheMode().isClustered() && this.configuration.versioning().scheme() == VersioningScheme.SIMPLE && this.configuration.versioning().enabled();
        this.isL1Enabled = this.configuration.clustering().l1().enabled();
    }

    @Override
    public final CacheEntry wrapEntryForReading(InvocationContext ctx, Object key, CacheEntry existing) {
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        if (cacheEntry == null) {
            CacheEntry cacheEntry2 = cacheEntry = existing == null ? this.getFromContainer(key, false) : existing;
            if (this.useRepeatableRead) {
                MVCCEntry mvccEntry;
                if (cacheEntry == null) {
                    mvccEntry = this.createWrappedEntry(key, null, ctx, null, false, false, false);
                } else {
                    mvccEntry = this.createWrappedEntry(key, cacheEntry, ctx, null, false, false, false);
                    if (cacheEntry instanceof StateChangingEntry && mvccEntry != null) {
                        mvccEntry.copyStateFlagsFrom((StateChangingEntry)((Object)cacheEntry));
                    }
                }
                if (mvccEntry != null) {
                    ctx.putLookedUpEntry(key, mvccEntry);
                }
                if (this.trace) {
                    log.tracef("Wrap %s for read. Entry=%s", key, mvccEntry);
                }
                return mvccEntry;
            }
            if (cacheEntry != null) {
                ctx.putLookedUpEntry(key, cacheEntry);
            }
            if (this.trace) {
                log.tracef("Wrap %s for read. Entry=%s", key, cacheEntry);
            }
            return cacheEntry;
        }
        if (this.trace) {
            log.tracef("Wrap %s for read. Entry=%s", key, cacheEntry);
        }
        return cacheEntry;
    }

    @Override
    public final MVCCEntry wrapEntryForClear(InvocationContext ctx, Object key) throws InterruptedException {
        MVCCEntry mvccEntry = this.wrapEntry(ctx, key, null, true);
        if (this.trace) {
            log.tracef("Wrap %s for clear. Entry=%s", key, mvccEntry);
        }
        return mvccEntry;
    }

    @Override
    public final MVCCEntry wrapEntryForReplace(InvocationContext ctx, ReplaceCommand cmd) throws InterruptedException {
        Object key = cmd.getKey();
        MVCCEntry mvccEntry = this.wrapEntry(ctx, key, cmd.getMetadata(), false);
        if (mvccEntry == null) {
            ctx.putLookedUpEntry(key, null);
        }
        if (this.trace) {
            log.tracef("Wrap %s for replace. Entry=%s", key, mvccEntry);
        }
        return mvccEntry;
    }

    @Override
    public final MVCCEntry wrapEntryForRemove(InvocationContext ctx, Object key, boolean skipRead, boolean forInvalidation, boolean forceWrap) throws InterruptedException {
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        MVCCEntry mvccEntry = null;
        if (cacheEntry != null) {
            mvccEntry = cacheEntry instanceof MVCCEntry ? (MVCCEntry)cacheEntry : this.wrapMvccEntryForRemove(ctx, key, cacheEntry, true);
        } else {
            InternalCacheEntry ice = this.getFromContainer(key, forInvalidation);
            if (ice != null || this.clusterModeWriteSkewCheck || forceWrap) {
                mvccEntry = this.wrapInternalCacheEntryForPut(ctx, key, ice, null, skipRead);
            }
        }
        if (mvccEntry == null) {
            ctx.putLookedUpEntry(key, null);
        } else {
            mvccEntry.copyForUpdate(this.container);
        }
        if (this.trace) {
            log.tracef("Wrap %s for remove. Entry=%s", key, mvccEntry);
        }
        return mvccEntry;
    }

    @Override
    public MVCCEntry wrapEntryForPut(InvocationContext ctx, Object key, InternalCacheEntry icEntry, boolean undeleteIfNeeded, FlagAffectedCommand cmd, boolean skipRead) {
        MVCCEntry mvccEntry;
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        if (cacheEntry != null && cacheEntry.isNull() && !this.useRepeatableRead) {
            cacheEntry = null;
        }
        Metadata providedMetadata = cmd.getMetadata();
        if (cacheEntry != null) {
            if (this.useRepeatableRead) {
                if (!(cacheEntry instanceof RepeatableReadEntry)) {
                    throw new IllegalStateException("Cache entry stored in context should be a RepeatableReadEntry instance but it is " + cacheEntry.getClass().getCanonicalName());
                }
                mvccEntry = (MVCCEntry)cacheEntry;
                if (!mvccEntry.isRemoved() && !mvccEntry.skipLookup() && icEntry != null) {
                    mvccEntry.setValue(icEntry.getValue());
                    this.updateVersion(mvccEntry, icEntry.getMetadata());
                }
                if (!mvccEntry.isRemoved() && mvccEntry.isNull()) {
                    mvccEntry.setCreated(true);
                }
                this.updateMetadata(mvccEntry, providedMetadata);
            } else {
                mvccEntry = this.wrapMvccEntryForPut(ctx, key, cacheEntry, providedMetadata, true);
            }
            mvccEntry.undelete(undeleteIfNeeded);
        } else {
            InternalCacheEntry ice;
            InternalCacheEntry internalCacheEntry = ice = icEntry == null ? this.getFromContainer(key, false) : icEntry;
            if (ice != null && cmd.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
                ctx.putLookedUpEntry(key, null);
                if (this.trace) {
                    log.tracef("Wrap %s for put. Entry=null", key);
                }
                return null;
            }
            mvccEntry = ice != null ? this.wrapInternalCacheEntryForPut(ctx, key, ice, providedMetadata, skipRead) : this.newMvccEntryForPut(ctx, key, cmd, providedMetadata, skipRead);
        }
        mvccEntry.copyForUpdate(this.container);
        if (this.trace) {
            log.tracef("Wrap %s for put. Entry=%s", key, mvccEntry);
        }
        return mvccEntry;
    }

    @Override
    public CacheEntry wrapEntryForDelta(InvocationContext ctx, Object deltaKey, Delta delta) {
        CacheEntry cacheEntry = this.getFromContext(ctx, deltaKey);
        DeltaAwareCacheEntry deltaAwareEntry = null;
        if (cacheEntry != null) {
            deltaAwareEntry = this.wrapEntryForDelta(ctx, deltaKey, cacheEntry);
        } else {
            InternalCacheEntry ice = this.getFromContainer(deltaKey, false);
            if (ice != null) {
                deltaAwareEntry = this.newDeltaAwareCacheEntry(ctx, deltaKey, (DeltaAware)ice.getValue());
            }
        }
        if (deltaAwareEntry != null) {
            deltaAwareEntry.appendDelta(delta);
        }
        if (this.trace) {
            log.tracef("Wrap %s for delta. Entry=%s", deltaKey, deltaAwareEntry);
        }
        return deltaAwareEntry;
    }

    private DeltaAwareCacheEntry wrapEntryForDelta(InvocationContext ctx, Object key, CacheEntry cacheEntry) {
        if (cacheEntry instanceof DeltaAwareCacheEntry) {
            return (DeltaAwareCacheEntry)cacheEntry;
        }
        return this.wrapInternalCacheEntryForDelta(ctx, key, cacheEntry);
    }

    private DeltaAwareCacheEntry wrapInternalCacheEntryForDelta(InvocationContext ctx, Object key, CacheEntry cacheEntry) {
        DeltaAwareCacheEntry e;
        if (cacheEntry instanceof MVCCEntry) {
            e = this.createWrappedDeltaEntry(key, (DeltaAware)cacheEntry.getValue(), cacheEntry);
        } else if (cacheEntry instanceof InternalCacheEntry) {
            cacheEntry = this.wrapInternalCacheEntryForPut(ctx, key, (InternalCacheEntry)cacheEntry, null, false);
            e = this.createWrappedDeltaEntry(key, (DeltaAware)cacheEntry.getValue(), cacheEntry);
        } else {
            e = this.createWrappedDeltaEntry(key, (DeltaAware)cacheEntry.getValue(), null);
        }
        ctx.putLookedUpEntry(key, e);
        return e;
    }

    private CacheEntry getFromContext(InvocationContext ctx, Object key) {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (this.trace) {
            log.tracef("Exists in context? %s ", cacheEntry);
        }
        return cacheEntry;
    }

    private InternalCacheEntry getFromContainer(Object key, boolean forceFetch) {
        InternalCacheEntry ice;
        boolean isLocal = this.distributionManager == null || this.distributionManager.getLocality(key).isLocal();
        InternalCacheEntry internalCacheEntry = ice = this.isL1Enabled || isLocal || forceFetch ? this.container.get(key) : null;
        if (this.trace) {
            log.tracef("Retrieved from container %s (isL1Enabled=%s, isLocal=%s)", ice, this.isL1Enabled, isLocal);
        }
        return ice;
    }

    private MVCCEntry newMvccEntryForPut(InvocationContext ctx, Object key, FlagAffectedCommand cmd, Metadata providedMetadata, boolean skipRead) {
        if (this.trace) {
            log.trace("Creating new entry.");
        }
        this.notifier.notifyCacheEntryCreated(key, null, true, ctx, cmd);
        MVCCEntry mvccEntry = this.createWrappedEntry(key, null, ctx, providedMetadata, true, false, skipRead);
        mvccEntry.setCreated(true);
        ctx.putLookedUpEntry(key, mvccEntry);
        return mvccEntry;
    }

    private MVCCEntry wrapMvccEntryForPut(InvocationContext ctx, Object key, CacheEntry cacheEntry, Metadata providedMetadata, boolean skipRead) {
        if (cacheEntry instanceof MVCCEntry) {
            MVCCEntry mvccEntry = (MVCCEntry)cacheEntry;
            this.updateMetadata(mvccEntry, providedMetadata);
            return mvccEntry;
        }
        return this.wrapInternalCacheEntryForPut(ctx, key, (InternalCacheEntry)cacheEntry, providedMetadata, skipRead);
    }

    private MVCCEntry wrapInternalCacheEntryForPut(InvocationContext ctx, Object key, InternalCacheEntry cacheEntry, Metadata providedMetadata, boolean skipRead) {
        MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry, ctx, providedMetadata, true, false, skipRead);
        ctx.putLookedUpEntry(key, mvccEntry);
        return mvccEntry;
    }

    private MVCCEntry wrapMvccEntryForRemove(InvocationContext ctx, Object key, CacheEntry cacheEntry, boolean skipRead) {
        MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry, ctx, null, false, true, skipRead);
        if (cacheEntry instanceof StateChangingEntry) {
            mvccEntry.copyStateFlagsFrom((StateChangingEntry)((Object)cacheEntry));
        }
        ctx.putLookedUpEntry(key, mvccEntry);
        return mvccEntry;
    }

    private MVCCEntry wrapEntry(InvocationContext ctx, Object key, Metadata providedMetadata, boolean skipRead) {
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        MVCCEntry mvccEntry = null;
        if (cacheEntry != null) {
            mvccEntry = this.wrapMvccEntryForPut(ctx, key, cacheEntry, providedMetadata, true);
        } else {
            InternalCacheEntry ice = this.getFromContainer(key, false);
            if (ice != null || this.clusterModeWriteSkewCheck) {
                mvccEntry = this.wrapInternalCacheEntryForPut(ctx, key, ice, providedMetadata, skipRead);
            }
        }
        if (mvccEntry != null) {
            mvccEntry.copyForUpdate(this.container);
        }
        return mvccEntry;
    }

    protected MVCCEntry createWrappedEntry(Object key, CacheEntry cacheEntry, InvocationContext context, Metadata providedMetadata, boolean isForInsert, boolean forRemoval, boolean skipRead) {
        Metadata metadata;
        Object value;
        Object v0 = value = cacheEntry != null ? cacheEntry.getValue() : null;
        Metadata metadata2 = providedMetadata != null ? providedMetadata : (metadata = cacheEntry != null ? cacheEntry.getMetadata() : null);
        if (value == null && !isForInsert && !this.useRepeatableRead) {
            return null;
        }
        return this.useRepeatableRead ? new RepeatableReadEntry(key, value, metadata) : new ReadCommittedEntry(key, value, metadata);
    }

    private DeltaAwareCacheEntry newDeltaAwareCacheEntry(InvocationContext ctx, Object key, DeltaAware deltaAware) {
        DeltaAwareCacheEntry deltaEntry = this.createWrappedDeltaEntry(key, deltaAware, null);
        ctx.putLookedUpEntry(key, deltaEntry);
        return deltaEntry;
    }

    private DeltaAwareCacheEntry createWrappedDeltaEntry(Object key, DeltaAware deltaAware, CacheEntry entry) {
        return new DeltaAwareCacheEntry(key, deltaAware, entry);
    }

    private void updateMetadata(MVCCEntry entry, Metadata providedMetadata) {
        if (this.trace) {
            log.tracef("Update metadata for %s. Provided metadata is %s", entry, providedMetadata);
        }
        if (providedMetadata == null || entry == null || entry.getMetadata() != null) {
            return;
        }
        entry.setMetadata(providedMetadata);
    }

    private void updateVersion(MVCCEntry entry, Metadata providedMetadata) {
        if (this.trace) {
            log.tracef("Update metadata for %s. Provided metadata is %s", entry, providedMetadata);
        }
        if (providedMetadata == null || entry == null) {
            return;
        }
        if (entry.getMetadata() == null) {
            entry.setMetadata(providedMetadata);
            return;
        }
        entry.setMetadata(Metadatas.applyVersion(entry.getMetadata(), providedMetadata));
    }
}

