/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.registry.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.filter.KeyFilter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.registry.ScopedKey;
import org.infinispan.registry.impl.SecurityActions;
import org.infinispan.transaction.TransactionMode;

@ThreadSafe
public class ClusterRegistryImpl<S, K, V>
implements ClusterRegistry<S, K, V> {
    public static final String GLOBAL_REGISTRY_CACHE_NAME = "__cluster_registry_cache__";
    private EmbeddedCacheManager cacheManager;
    private volatile Cache<ScopedKey<S, K>, V> clusterRegistryCache;
    private volatile AdvancedCache<ScopedKey<S, K>, V> clusterRegistryCacheWithoutReturn;

    @Inject
    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Stop(priority=1)
    public void stop() {
        if (this.clusterRegistryCache != null) {
            this.clusterRegistryCache.stop();
        }
        this.clusterRegistryCache = null;
    }

    @Override
    public void put(S scope, K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed");
        }
        this.startRegistryCache();
        this.clusterRegistryCacheWithoutReturn.put(new ScopedKey<S, K>(scope, key), value);
    }

    @Override
    public void put(S scope, K key, V value, long lifespan, TimeUnit unit) {
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed");
        }
        this.startRegistryCache();
        this.clusterRegistryCacheWithoutReturn.put(new ScopedKey<S, K>(scope, key), value, lifespan, unit);
    }

    @Override
    public void remove(S scope, K key) {
        this.startRegistryCache();
        this.clusterRegistryCacheWithoutReturn.remove(new ScopedKey<S, K>(scope, key));
    }

    @Override
    public V get(S scope, K key) {
        this.startRegistryCache();
        return (V)this.clusterRegistryCache.get(new ScopedKey<S, K>(scope, key));
    }

    @Override
    public boolean containsKey(S scope, K key) {
        V v = this.get(scope, key);
        return v != null;
    }

    @Override
    public Set<K> keys(S scope) {
        this.startRegistryCache();
        HashSet<K> result = new HashSet<K>();
        for (ScopedKey<S, K> key : this.clusterRegistryCache.keySet()) {
            if (!key.hasScope(scope)) continue;
            result.add(key.getKey());
        }
        return result;
    }

    @Override
    public void clear(S scope) {
        this.startRegistryCache();
        for (ScopedKey<S, K> key : this.clusterRegistryCache.keySet()) {
            if (!key.hasScope(scope)) continue;
            this.clusterRegistryCacheWithoutReturn.remove(key);
        }
    }

    @Override
    public void clearAll() {
        this.startRegistryCache();
        this.clusterRegistryCache.clear();
    }

    @Override
    public void addListener(final S scope, Object listener) {
        this.startRegistryCache();
        this.clusterRegistryCache.addListener(listener, new KeyFilter(){

            public boolean accept(Object key) {
                ScopedKey scopedKey = (ScopedKey)key;
                return scopedKey.hasScope(scope);
            }
        });
    }

    @Override
    public void addListener(final S scope, final KeyFilter keyFilter, Object listener) {
        this.startRegistryCache();
        this.clusterRegistryCache.addListener(listener, new KeyFilter(){

            public boolean accept(Object key) {
                ScopedKey scopedKey = (ScopedKey)key;
                return scopedKey.hasScope(scope) && keyFilter.accept(scopedKey.getKey());
            }
        });
    }

    @Override
    public void removeListener(Object listener) {
        if (this.clusterRegistryCache != null) {
            this.clusterRegistryCache.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRegistryCache() {
        if (this.clusterRegistryCache == null) {
            ClusterRegistryImpl clusterRegistryImpl = this;
            synchronized (clusterRegistryImpl) {
                if (this.clusterRegistryCache != null) {
                    return;
                }
                SecurityActions.defineConfiguration(this.cacheManager, GLOBAL_REGISTRY_CACHE_NAME, this.getRegistryCacheConfig());
                this.clusterRegistryCache = SecurityActions.getRegistryCache(this.cacheManager);
                this.clusterRegistryCacheWithoutReturn = this.clusterRegistryCache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
            }
        }
    }

    private Configuration getRegistryCacheConfig() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        CacheMode cacheMode = this.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        configurationBuilder.clustering().cacheMode(cacheMode);
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        configurationBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        return configurationBuilder.build();
    }

    private boolean isClustered() {
        GlobalConfiguration globalConfiguration = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
        return globalConfiguration.isClustered();
    }
}

