/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jgroups.Address;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Util;

public final class JGroupsTopologyAwareAddress
extends JGroupsAddress
implements TopologyAwareAddress {
    protected static final byte[] SITE_ID = Util.stringToBytes((String)"site-id");
    protected static final byte[] RACK_ID = Util.stringToBytes((String)"rack-id");
    protected static final byte[] MACHINE_ID = Util.stringToBytes((String)"machine-id");
    private final ExtendedUUID topologyAddress;

    public JGroupsTopologyAwareAddress(ExtendedUUID address) {
        super((Address)address);
        this.topologyAddress = address;
    }

    @Override
    public String getSiteId() {
        return Util.bytesToString((byte[])this.topologyAddress.get(SITE_ID));
    }

    @Override
    public String getRackId() {
        return Util.bytesToString((byte[])this.topologyAddress.get(RACK_ID));
    }

    @Override
    public String getMachineId() {
        return Util.bytesToString((byte[])this.topologyAddress.get(MACHINE_ID));
    }

    @Override
    public boolean isSameSite(TopologyAwareAddress addr) {
        return this.getSiteId() == null ? addr.getSiteId() == null : this.getSiteId().equals(addr.getSiteId());
    }

    @Override
    public boolean isSameRack(TopologyAwareAddress addr) {
        if (!this.isSameSite(addr)) {
            return false;
        }
        return this.getRackId() == null ? addr.getRackId() == null : this.getRackId().equals(addr.getRackId());
    }

    @Override
    public boolean isSameMachine(TopologyAwareAddress addr) {
        if (!this.isSameRack(addr)) {
            return false;
        }
        return this.getMachineId() == null ? addr.getMachineId() == null : this.getMachineId().equals(addr.getMachineId());
    }

    public static final class Externalizer
    implements AdvancedExternalizer<JGroupsTopologyAwareAddress> {
        public void writeObject(ObjectOutput output, JGroupsTopologyAwareAddress address) throws IOException {
            try {
                Util.writeAddress((Address)address.address, (DataOutput)output);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public JGroupsTopologyAwareAddress readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            try {
                ExtendedUUID jgroupsAddress = (ExtendedUUID)Util.readAddress((DataInput)unmarshaller);
                return new JGroupsTopologyAwareAddress(jgroupsAddress);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public Set<Class<? extends JGroupsTopologyAwareAddress>> getTypeClasses() {
            return Collections.singleton(JGroupsTopologyAwareAddress.class);
        }

        public Integer getId() {
            return 60;
        }
    }
}

