/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CommitManager {
    private static final Log log = LogFactory.getLog(CommitManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private final EquivalentConcurrentHashMapV8<Object, DiscardPolicy> tracker;
    private DataContainer dataContainer;
    private volatile boolean trackStateTransfer;
    private volatile boolean trackXSiteStateTransfer;

    public CommitManager(Equivalence<Object> keyEq) {
        this.tracker = new EquivalentConcurrentHashMapV8(keyEq, (Equivalence)AnyEquivalence.getInstance());
    }

    @Inject
    public final void inject(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    public final void startTrack(Flag track) {
        this.setTrack(track, true);
    }

    public final void stopTrack(Flag track) {
        this.setTrack(track, false);
        if (!this.trackStateTransfer && !this.trackXSiteStateTransfer) {
            if (trace) {
                log.tracef("Tracking is disabled. Clear tracker: %s", this.tracker);
            }
            this.tracker.clear();
        }
    }

    public final void commit(final CacheEntry entry, final Metadata metadata, final Flag operation, boolean l1Invalidation) {
        if (trace) {
            log.tracef("Trying to commit. Key=%s. Operation Flag=%s, L1 invalidation=%s", entry.getKey(), (Object)operation, l1Invalidation);
        }
        if (l1Invalidation || operation == null && !this.trackStateTransfer && !this.trackXSiteStateTransfer) {
            if (trace) {
                log.tracef("Committing key=%s. It is a L1 invalidation or a normal put and no tracking is enabled!", entry.getKey());
            }
            entry.commit(this.dataContainer, metadata);
            return;
        }
        if (this.isTrackDisabled(operation)) {
            if (trace) {
                log.tracef("Not committing key=%s. It is a state transfer key but no track is enabled!", entry.getKey());
            }
            return;
        }
        this.tracker.compute(entry.getKey(), (EquivalentConcurrentHashMapV8.BiFun)new EquivalentConcurrentHashMapV8.BiFun<Object, DiscardPolicy, DiscardPolicy>(){

            public DiscardPolicy apply(Object o, DiscardPolicy discardPolicy) {
                if (discardPolicy != null && discardPolicy.ignore(operation)) {
                    if (trace) {
                        log.tracef("Not committing key=%s. It was already overwritten! Discard policy=%s", entry.getKey(), (Object)discardPolicy);
                    }
                    return discardPolicy;
                }
                entry.commit(CommitManager.this.dataContainer, metadata);
                DiscardPolicy newDiscardPolicy = CommitManager.this.calculateDiscardPolicy();
                if (trace) {
                    log.tracef("Committed key=%s. Old discard policy=%s. New discard policy=%s", entry.getKey(), (Object)discardPolicy, (Object)newDiscardPolicy);
                }
                return newDiscardPolicy;
            }
        });
    }

    public final boolean isTracking(Flag trackFlag) {
        switch (trackFlag) {
            case PUT_FOR_STATE_TRANSFER: {
                return this.trackStateTransfer;
            }
            case PUT_FOR_X_SITE_STATE_TRANSFER: {
                return this.trackXSiteStateTransfer;
            }
        }
        return false;
    }

    public final boolean isEmpty() {
        return this.tracker.isEmpty();
    }

    private void setTrack(Flag track, boolean value) {
        if (trace) {
            log.tracef("Set track to %s = %s", (Object)track, value);
        }
        switch (track) {
            case PUT_FOR_STATE_TRANSFER: {
                this.trackStateTransfer = value;
                return;
            }
            case PUT_FOR_X_SITE_STATE_TRANSFER: {
                this.trackXSiteStateTransfer = value;
            }
        }
    }

    private boolean isTrackDisabled(Flag track) {
        return track == Flag.PUT_FOR_STATE_TRANSFER && !this.trackStateTransfer || track == Flag.PUT_FOR_X_SITE_STATE_TRANSFER && !this.trackXSiteStateTransfer;
    }

    private DiscardPolicy calculateDiscardPolicy() {
        if (this.trackStateTransfer && this.trackXSiteStateTransfer) {
            return DiscardPolicy.DISCARD_ALL_STATE_TRANSFER;
        }
        if (this.trackStateTransfer) {
            return DiscardPolicy.DISCARD_STATE_TRANSFER;
        }
        if (this.trackXSiteStateTransfer) {
            return DiscardPolicy.DISCARD_X_SITE_STATE_TRANSFER;
        }
        return null;
    }

    private static enum DiscardPolicy {
        DISCARD_STATE_TRANSFER{

            @Override
            public boolean ignore(Flag operation) {
                return operation == Flag.PUT_FOR_STATE_TRANSFER;
            }
        }
        ,
        DISCARD_X_SITE_STATE_TRANSFER{

            @Override
            public boolean ignore(Flag operation) {
                return operation == Flag.PUT_FOR_X_SITE_STATE_TRANSFER;
            }
        }
        ,
        DISCARD_ALL_STATE_TRANSFER{

            @Override
            public boolean ignore(Flag operation) {
                return operation == Flag.PUT_FOR_STATE_TRANSFER || operation == Flag.PUT_FOR_X_SITE_STATE_TRANSFER;
            }
        };


        public abstract boolean ignore(Flag var1);
    }
}

