/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareConsistentHashFactory;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.distribution.group.GroupingConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferManagerImpl
implements StateTransferManager {
    private static final Log log = LogFactory.getLog(StateTransferManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private StateConsumer stateConsumer;
    private StateProvider stateProvider;
    private String cacheName;
    private CacheNotifier cacheNotifier;
    private Configuration configuration;
    private GlobalConfiguration globalConfiguration;
    private RpcManager rpcManager;
    private GroupManager groupManager;
    private LocalTopologyManager localTopologyManager;
    private final CountDownLatch initialStateTransferComplete = new CountDownLatch(1);
    private volatile int firstTopologyAsMember = Integer.MAX_VALUE;

    @Inject
    public void init(StateConsumer stateConsumer, StateProvider stateProvider, Cache cache, CacheNotifier cacheNotifier, Configuration configuration, GlobalConfiguration globalConfiguration, RpcManager rpcManager, GroupManager groupManager, LocalTopologyManager localTopologyManager) {
        this.stateConsumer = stateConsumer;
        this.stateProvider = stateProvider;
        this.cacheName = cache.getName();
        this.cacheNotifier = cacheNotifier;
        this.configuration = configuration;
        this.globalConfiguration = globalConfiguration;
        this.rpcManager = rpcManager;
        this.groupManager = groupManager;
        this.localTopologyManager = localTopologyManager;
    }

    @Override
    @Start(priority=60)
    public void start() throws Exception {
        if (trace) {
            log.tracef("Starting StateTransferManager of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        CacheJoinInfo joinInfo = new CacheJoinInfo(this.pickConsistentHashFactory(), this.configuration.clustering().hash().hash(), this.configuration.clustering().hash().numSegments(), this.configuration.clustering().hash().numOwners(), this.configuration.clustering().stateTransfer().timeout(), this.configuration.transaction().transactionProtocol().isTotalOrder(), this.configuration.clustering().cacheMode().isDistributed(), this.configuration.clustering().hash().capacityFactor());
        CacheTopology initialTopology = this.localTopologyManager.join(this.cacheName, joinInfo, new CacheTopologyHandler(){

            @Override
            public void updateConsistentHash(CacheTopology cacheTopology) {
                StateTransferManagerImpl.this.doTopologyUpdate(cacheTopology, false);
            }

            @Override
            public void rebalance(CacheTopology cacheTopology) {
                StateTransferManagerImpl.this.doTopologyUpdate(cacheTopology, true);
            }
        });
        if (trace) {
            log.tracef("StateTransferManager of cache %s on node %s received initial topology %s", this.cacheName, this.rpcManager.getAddress(), initialTopology);
        }
    }

    private ConsistentHashFactory pickConsistentHashFactory() {
        CacheMode cacheMode;
        ConsistentHashFactory<DefaultConsistentHash> factory = this.configuration.clustering().hash().consistentHashFactory();
        if (factory == null && (cacheMode = this.configuration.clustering().cacheMode()).isClustered()) {
            factory = cacheMode.isDistributed() ? (this.globalConfiguration.transport().hasTopologyInfo() ? new TopologyAwareConsistentHashFactory() : new DefaultConsistentHashFactory()) : new ReplicatedConsistentHashFactory();
        }
        return factory;
    }

    private CacheTopology addGrouping(CacheTopology cacheTopology) {
        ConsistentHash unionCH;
        if (this.groupManager == null) {
            return cacheTopology;
        }
        ConsistentHash currentCH = cacheTopology.getCurrentCH();
        currentCH = new GroupingConsistentHash(currentCH, this.groupManager);
        ConsistentHash pendingCH = cacheTopology.getPendingCH();
        if (pendingCH != null) {
            pendingCH = new GroupingConsistentHash(pendingCH, this.groupManager);
        }
        if ((unionCH = cacheTopology.getUnionCH()) != null) {
            unionCH = new GroupingConsistentHash(unionCH, this.groupManager);
        }
        return new CacheTopology(cacheTopology.getTopologyId(), currentCH, pendingCH, unionCH);
    }

    private void doTopologyUpdate(CacheTopology newCacheTopology, boolean isRebalance) {
        boolean isJoined;
        CacheTopology oldCacheTopology = this.stateConsumer.getCacheTopology();
        if (oldCacheTopology != null && oldCacheTopology.getTopologyId() > newCacheTopology.getTopologyId()) {
            throw new IllegalStateException("Old topology is higher: old=" + oldCacheTopology + ", new=" + newCacheTopology);
        }
        if (isRebalance && oldCacheTopology != null && oldCacheTopology.getPendingCH() != null) {
            if (newCacheTopology.getTopologyId() < oldCacheTopology.getTopologyId() + 2) {
                throw new IllegalArgumentException("Received a rebalance start topology " + newCacheTopology + " while there already was a rebalance in progress: " + oldCacheTopology);
            }
            CacheTopology resetTopology = new CacheTopology(newCacheTopology.getTopologyId() - 1, newCacheTopology.getCurrentCH(), null);
            this.doTopologyUpdate(resetTopology, false);
        }
        if (trace) {
            log.tracef("Installing new cache topology %s on cache %s", newCacheTopology, this.cacheName);
        }
        if (this.firstTopologyAsMember == Integer.MAX_VALUE && newCacheTopology.getMembers().contains(this.rpcManager.getAddress())) {
            if (trace) {
                log.trace("This is the first topology in which the local node is a member");
            }
            this.firstTopologyAsMember = newCacheTopology.getTopologyId();
        }
        newCacheTopology = this.addGrouping(newCacheTopology);
        this.cacheNotifier.notifyTopologyChanged(oldCacheTopology, newCacheTopology, newCacheTopology.getTopologyId(), true);
        this.stateConsumer.onTopologyUpdate(newCacheTopology, isRebalance);
        this.stateProvider.onTopologyUpdate(newCacheTopology, isRebalance);
        this.cacheNotifier.notifyTopologyChanged(oldCacheTopology, newCacheTopology, newCacheTopology.getTopologyId(), false);
        if (this.initialStateTransferComplete.getCount() > 0L && (isJoined = this.stateConsumer.getCacheTopology().getReadConsistentHash().getMembers().contains(this.rpcManager.getAddress()))) {
            this.initialStateTransferComplete.countDown();
            log.tracef("Initial state transfer complete for cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
    }

    @Start(priority=1000)
    public void waitForInitialStateTransferToComplete() throws InterruptedException {
        if (this.configuration.clustering().stateTransfer().awaitInitialTransfer()) {
            boolean success;
            if (trace) {
                log.tracef("Waiting for initial state transfer to finish for cache %s on %s", this.cacheName, this.rpcManager.getAddress());
            }
            if (!(success = this.initialStateTransferComplete.await(this.configuration.clustering().stateTransfer().timeout(), TimeUnit.MILLISECONDS))) {
                throw new CacheException(String.format("Initial state transfer timed out for cache %s on %s", this.cacheName, this.rpcManager.getAddress()));
            }
        }
    }

    @Override
    @Stop(priority=20)
    public void stop() {
        if (trace) {
            log.tracef("Shutting down StateTransferManager of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        this.initialStateTransferComplete.countDown();
        this.localTopologyManager.leave(this.cacheName);
    }

    @Override
    public boolean isJoinComplete() {
        return this.stateConsumer.getCacheTopology() != null;
    }

    @Override
    public boolean isStateTransferInProgress() {
        return this.stateConsumer.isStateTransferInProgress();
    }

    @Override
    public boolean isStateTransferInProgressForKey(Object key) {
        return this.stateConsumer.isStateTransferInProgressForKey(key);
    }

    @Override
    public CacheTopology getCacheTopology() {
        return this.stateConsumer.getCacheTopology();
    }

    @Override
    public Map<Address, Response> forwardCommandIfNeeded(TopologyAffectedCommand command, Set<Object> affectedKeys, Address origin, boolean sync) {
        int localTopologyId;
        int cmdTopologyId = command.getTopologyId();
        CacheTopology cacheTopology = this.getCacheTopology();
        int n = localTopologyId = cacheTopology != null ? cacheTopology.getTopologyId() : -1;
        if (trace) {
            log.tracef("CommandTopologyId=%s, localTopologyId=%s", cmdTopologyId, localTopologyId);
        }
        if (cmdTopologyId < localTopologyId) {
            ConsistentHash writeCh = cacheTopology.getWriteConsistentHash();
            HashSet<Address> newTargets = new HashSet<Address>(writeCh.locateAllOwners(affectedKeys));
            newTargets.remove(this.rpcManager.getAddress());
            newTargets.remove(origin);
            if (!newTargets.isEmpty()) {
                command.setTopologyId(localTopologyId);
                if (trace) {
                    log.tracef("Forwarding command %s to new targets %s", command, newTargets);
                }
                return this.rpcManager.invokeRemotely(newTargets, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(sync, false));
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public void notifyEndOfRebalance(int topologyId) {
        this.localTopologyManager.confirmRebalance(this.cacheName, topologyId, null);
    }

    @Override
    public boolean ownsData() {
        return this.stateConsumer.ownsData();
    }

    @Override
    public int getFirstTopologyAsMember() {
        return this.firstTopologyAsMember;
    }

    public String toString() {
        return "StateTransferManagerImpl [" + this.cacheName + "@" + this.rpcManager.getAddress() + "]";
    }
}

