/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.infinispan.util.TimeService;

public class DefaultMassIndexerProgressMonitor
implements MassIndexerProgressMonitor {
    private static final Log log = LoggerFactory.make();
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;
    private final TimeService timeService;

    public DefaultMassIndexerProgressMonitor(TimeService timeService) {
        this(50, timeService);
    }

    public DefaultMassIndexerProgressMonitor(int logAfterNumberOfDocuments, TimeService timeService) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
        this.timeService = timeService;
    }

    public void entitiesLoaded(int size) {
    }

    public void documentsAdded(long increment) {
        long current = this.documentsDoneCounter.addAndGet(increment);
        if (current == increment) {
            this.startTime = this.timeService.time();
        }
        if (current % (long)this.getStatusMessagePeriod() == 0L) {
            this.printStatusMessage(this.startTime, current);
        }
    }

    public void documentsBuilt(int number) {
    }

    public void addToTotalCount(long count) {
    }

    public void indexingCompleted() {
        log.indexingEntitiesCompleted(this.documentsDoneCounter.get());
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long doneCount) {
        log.indexingDocumentsCompleted(doneCount, this.timeService.timeDuration(startTime, TimeUnit.MILLISECONDS));
    }
}

