/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.hql.FilterProcessingChain;
import org.infinispan.objectfilter.impl.hql.ReflectionPropertyHelper;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.ReflectionMatcherEvalContext;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;

public final class ReflectionMatcher
extends BaseMatcher<Class<?>, String> {
    private final ClassLoader classLoader;

    public ReflectionMatcher(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    protected MatcherEvalContext<String> startContext(Object instance, Set<String> knownTypes) {
        String typeName = instance.getClass().getCanonicalName();
        if (knownTypes.contains(typeName)) {
            return new ReflectionMatcherEvalContext(instance);
        }
        return null;
    }

    @Override
    protected FilterProcessingChain<Class<?>> createFilterProcessingChain(Map<String, Object> namedParameters) {
        return FilterProcessingChain.build(new ReflectionPropertyHelper(this.classLoader), namedParameters);
    }

    @Override
    protected FilterRegistry<String> createFilterRegistryForType(Class<?> clazz) {
        return new FilterRegistry<String>(new MetadataAdapterImpl(clazz));
    }

    private static class MetadataAdapterImpl
    implements MetadataAdapter<ReflectionHelper.PropertyAccessor, String> {
        private final Class<?> clazz;

        MetadataAdapterImpl(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public String getTypeName() {
            return this.clazz.getName();
        }

        @Override
        public Class<?> getTypeMetadata() {
            return this.clazz;
        }

        @Override
        public List<String> translatePropertyPath(List<String> path) {
            return path;
        }

        @Override
        public boolean isRepeatedProperty(List<String> propertyPath) {
            ReflectionHelper.PropertyAccessor a = ReflectionHelper.getAccessor(this.clazz, propertyPath.get(0));
            if (a.isMultiple()) {
                return true;
            }
            for (int i = 1; i < propertyPath.size(); ++i) {
                if (!(a = a.getAccessor(propertyPath.get(i))).isMultiple()) continue;
                return true;
            }
            return false;
        }

        @Override
        public ReflectionHelper.PropertyAccessor makeChildAttributeMetadata(ReflectionHelper.PropertyAccessor parentAttributeMetadata, String attribute) {
            return parentAttributeMetadata == null ? ReflectionHelper.getAccessor(this.clazz, attribute) : parentAttributeMetadata.getAccessor(attribute);
        }

        @Override
        public boolean isComparableProperty(ReflectionHelper.PropertyAccessor attributeMetadata) {
            Class<?> propertyType = attributeMetadata.getPropertyType();
            return propertyType != null && (propertyType.isPrimitive() || Comparable.class.isAssignableFrom(propertyType));
        }
    }
}

