/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.Predicates;
import org.infinispan.objectfilter.impl.predicateindex.Projections;

public class AttributeNode<AttributeId extends Comparable<AttributeId>> {
    private final AttributeId attribute;
    private final Object metadata;
    private final MetadataAdapter metadataAdapter;
    private final AttributeNode<AttributeId> parent;
    private Map<AttributeId, AttributeNode<AttributeId>> children;
    private Predicates predicates;
    private Projections projections;

    protected AttributeNode(MetadataAdapter metadataAdapter) {
        this.attribute = null;
        this.parent = null;
        this.metadataAdapter = metadataAdapter;
        this.metadata = null;
    }

    private AttributeNode(AttributeId attribute, AttributeNode<AttributeId> parent) {
        this.attribute = attribute;
        this.parent = parent;
        this.metadataAdapter = parent.metadataAdapter;
        this.metadata = this.metadataAdapter.makeChildAttributeMetadata(parent.metadata, attribute);
    }

    public AttributeId getAttribute() {
        return this.attribute;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public AttributeNode<AttributeId> getParent() {
        return this.parent;
    }

    public Iterator<AttributeNode<AttributeId>> getChildrenIterator() {
        return this.children != null ? this.children.values().iterator() : Collections.emptyList().iterator();
    }

    public AttributeNode<AttributeId> getChild(AttributeId attribute) {
        if (this.children != null) {
            return this.children.get(attribute);
        }
        return null;
    }

    public int getNumChildren() {
        return this.children != null ? this.children.size() : 0;
    }

    public boolean hasPredicates() {
        return this.predicates != null && !this.predicates.isEmpty();
    }

    public boolean hasProjections() {
        return this.projections != null && this.projections.hasProjections();
    }

    public void processValue(Object attributeValue, MatcherEvalContext<AttributeId> ctx) {
        if (this.projections != null) {
            this.projections.processProjections(ctx, attributeValue);
        }
        if (this.predicates != null) {
            this.predicates.notifyMatchingSubscribers(ctx, attributeValue);
        }
    }

    public AttributeNode<AttributeId> addChild(AttributeId attribute) {
        AttributeNode<AttributeId> child;
        if (this.children == null) {
            this.children = new HashMap<AttributeId, AttributeNode<AttributeId>>();
            child = new AttributeNode<AttributeId>(attribute, this);
            this.children.put(attribute, child);
        } else {
            child = this.children.get(attribute);
            if (child == null) {
                child = new AttributeNode<AttributeId>(attribute, this);
                this.children.put(attribute, child);
            }
        }
        return child;
    }

    public void removeChild(AttributeId attribute) {
        if (this.children == null) {
            throw new IllegalArgumentException("No child found : " + attribute);
        }
        AttributeNode<AttributeId> child = this.children.get(attribute);
        if (child == null) {
            throw new IllegalArgumentException("No child found : " + attribute);
        }
        this.children.remove(attribute);
    }

    public void addPredicateSubscription(PredicateIndex.Subscription subscription) {
        if (this.predicates == null) {
            this.predicates = new Predicates(this.metadataAdapter.isComparableProperty(this.metadata));
        }
        this.predicates.addPredicate(subscription);
    }

    public void removePredicateSubscription(PredicateIndex.Subscription subscription) {
        if (this.predicates == null) {
            throw new IllegalStateException("Reached illegal state");
        }
        this.predicates.removePredicate(subscription);
    }

    public void addProjection(FilterSubscriptionImpl filterSubscription, int position) {
        if (this.projections == null) {
            this.projections = new Projections();
        }
        this.projections.addProjection(filterSubscription, position);
    }

    public void removeProjections(FilterSubscriptionImpl filterSubscription) {
        if (this.projections == null) {
            throw new IllegalStateException("Reached illegal state");
        }
        this.projections.removeProjections(filterSubscription);
    }

    public String toString() {
        return "AttributeNode(" + this.attribute + ')';
    }
}

