/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.Arrays;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;

public final class FilterEvalContext {
    public final BETree beTree;
    public final int[] treeCounters;
    public final MatcherEvalContext<?> matcherContext;
    public final Object[] projection;
    public final Comparable[] sortProjection;

    public FilterEvalContext(BETree beTree, MatcherEvalContext<?> matcherContext, Object[] projection, Comparable[] sortProjection) {
        this.beTree = beTree;
        this.matcherContext = matcherContext;
        int[] childCounters = beTree.getChildCounters();
        this.treeCounters = Arrays.copyOf(childCounters, childCounters.length);
        this.projection = projection;
        this.sortProjection = sortProjection;
    }

    public boolean getMatchResult() {
        return this.treeCounters[0] == 0;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    public Comparable[] getSortProjection() {
        return this.sortProjection;
    }
}

